/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.micronaut;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class ProviderImplementationsToMicronautFactories
extends Recipe {
    private static final List<AnnotationMatcher> BEAN_ANNOTATION_MATCHERS = Stream.concat(Stream.of("io.micronaut.context.annotation.Bean", "io.micronaut.context.annotation.Context", "io.micronaut.context.annotation.Prototype", "io.micronaut.context.annotation.Infrastructure", "io.micronaut.runtime.context.scope.Refreshable", "io.micronaut.runtime.context.scope.ThreadLocal", "io.micronaut.runtime.http.scope.RequestScope").map(it -> new AnnotationMatcher("@" + it)), Stream.of("@javax.inject", "@jakarta.inject").map(it -> new AnnotationMatcher(it + ".Singleton"))).map(AnnotationMatcher.class::cast).collect(Collectors.toList());

    public String getDisplayName() {
        return "`Provider` implementation beans to Micronaut `@Factory`";
    }

    public String getDescription() {
        return "As of Micronaut 3.x the `@Factory` annotation is required for creating beans from `javax.inject.Provider get()` implementations.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("javax.inject.Provider", Boolean.valueOf(false)), new UsesType("jakarta.inject.Provider", Boolean.valueOf(false))}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
                if (cu.getClasses().stream().anyMatch(cd -> ProviderImplementationsToMicronautFactories.isProvider(cd) && cd.getLeadingAnnotations().stream().anyMatch(x$0 -> ProviderImplementationsToMicronautFactories.isBeanAnnotation(x$0)))) {
                    this.doAfterVisit((TreeVisitor)new ProviderImplementationsGenerateFactoriesVisitor());
                }
                return cu;
            }
        });
    }

    private static boolean isBeanAnnotation(J.Annotation annotation) {
        return BEAN_ANNOTATION_MATCHERS.stream().anyMatch(annotationMatcher -> annotationMatcher.matches(annotation));
    }

    private static boolean isProvider(J.ClassDeclaration classDecl) {
        return classDecl.getType() != null && classDecl.getImplements() != null && (classDecl.getImplements().stream().anyMatch(impl -> TypeUtils.isOfClassType((JavaType)impl.getType(), (String)"javax.inject.Provider")) || classDecl.getImplements().stream().anyMatch(impl -> TypeUtils.isOfClassType((JavaType)impl.getType(), (String)"jakarta.inject.Provider")));
    }

    private static class ProviderImplementationsGenerateFactoriesVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private ProviderImplementationsGenerateFactoriesVisitor() {
        }

        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
            List beanAnnotations = classDecl.getLeadingAnnotations().stream().filter(x$0 -> ProviderImplementationsToMicronautFactories.isBeanAnnotation(x$0)).collect(Collectors.toList());
            if (classDecl.getType() == null || !ProviderImplementationsToMicronautFactories.isProvider(classDecl) || beanAnnotations.isEmpty()) {
                return classDecl;
            }
            this.getCursor().putMessage("provider-get", (Object)new MethodMatcher(classDecl.getType().getFullyQualifiedName() + " get()"));
            this.getCursor().putMessage("class-bean-annotations", beanAnnotations);
            J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
            cd = cd.withLeadingAnnotations(ListUtils.map((List)cd.getLeadingAnnotations(), anno -> {
                if (ProviderImplementationsToMicronautFactories.isBeanAnnotation(anno)) {
                    return null;
                }
                return anno;
            }));
            cd = (J.ClassDeclaration)JavaTemplate.builder((String)"@Factory").imports(new String[]{"io.micronaut.context.annotation.Factory"}).javaParser(JavaParser.fromJavaVersion().dependsOn(new String[]{"package io.micronaut.context.annotation; public @interface Factory {}"})).build().apply(new Cursor(this.getCursor().getParent(), (Object)cd), cd.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[0]);
            this.maybeAddImport("io.micronaut.context.annotation.Factory");
            return cd;
        }

        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
            List newBeanAnnotations;
            J.MethodDeclaration md = super.visitMethodDeclaration(method, (Object)ctx);
            Cursor classDeclCursor = this.getCursor().dropParentUntil(J.ClassDeclaration.class::isInstance);
            MethodMatcher mm = (MethodMatcher)classDeclCursor.getMessage("provider-get");
            List beanAnnotations = (List)classDeclCursor.getMessage("class-bean-annotations");
            if (mm != null && mm.matches(md.getMethodType()) && beanAnnotations != null && !(newBeanAnnotations = beanAnnotations.stream().filter(anno -> !this.annotationExists(method.getLeadingAnnotations(), (J.Annotation)anno)).collect(Collectors.toList())).isEmpty()) {
                md = (J.MethodDeclaration)this.maybeAutoFormat((J)md, (J)md.withLeadingAnnotations(ListUtils.concatAll((List)md.getLeadingAnnotations(), newBeanAnnotations)), ctx, this.getCursor().getParent());
            }
            return md;
        }

        private boolean annotationExists(List<J.Annotation> annotations, J.Annotation annotation) {
            return annotations.stream().anyMatch(anno -> {
                JavaType.FullyQualified fq = TypeUtils.asFullyQualified((JavaType)anno.getType());
                return fq != null && fq.isAssignableFrom((JavaType)TypeUtils.asFullyQualified((JavaType)annotation.getType()));
            });
        }
    }
}

