/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.micronaut;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;

public class TypeRequiresIntrospection
extends ScanningRecipe<Accumulator> {
    private static final Collection<String> typesRequiringIntrospection = Arrays.asList("io.micronaut.http.annotation.Controller", "io.micronaut.http.client.annotation.Client");

    public String getDisplayName() {
        return "Add `@Introspected` to classes requiring a map representation";
    }

    public String getDescription() {
        return "In Micronaut 2.x a reflection-based strategy was used to retrieve that information if the class was not annotated with `@Introspected`. As of Micronaut 3.x it is required to annotate classes with `@Introspected` that are used in this way.";
    }

    private static boolean parentRequiresIntrospection(// Could not load outer class - annotation placement on inner may be incorrect
    @Nullable JavaType.FullyQualified type) {
        if (type == null) {
            return false;
        }
        for (JavaType.FullyQualified fullyQualified : type.getAnnotations()) {
            if (!typesRequiringIntrospection.contains(fullyQualified.getFullyQualifiedName())) continue;
            return true;
        }
        return false;
    }

    public Accumulator getInitialValue(ExecutionContext ctx) {
        return new Accumulator();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Accumulator acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                FindParamsAndReturnTypes findParamsAndReturnTypes = new FindParamsAndReturnTypes();
                if (tree instanceof J.CompilationUnit) {
                    J.CompilationUnit cu = (J.CompilationUnit)tree;
                    for (J.ClassDeclaration classDeclaration : cu.getClasses()) {
                        if (!TypeRequiresIntrospection.parentRequiresIntrospection(classDeclaration.getType())) continue;
                        findParamsAndReturnTypes.visit((Tree)classDeclaration, acc.getIntrospectableTypes());
                    }
                }
                return tree;
            }
        };
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(Accumulator acc) {
        return new AddIntrospectionAnnotationVisitor(acc.getIntrospectableTypes());
    }

    static class Accumulator {
        Set<JavaType.FullyQualified> introspectableTypes = new HashSet<JavaType.FullyQualified>();

        @Generated
        public Accumulator() {
        }

        @Generated
        public Set<JavaType.FullyQualified> getIntrospectableTypes() {
            return this.introspectableTypes;
        }

        @Generated
        public void setIntrospectableTypes(Set<JavaType.FullyQualified> introspectableTypes) {
            this.introspectableTypes = introspectableTypes;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Accumulator)) {
                return false;
            }
            Accumulator other = (Accumulator)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Set<JavaType.FullyQualified> this$introspectableTypes = this.getIntrospectableTypes();
            Set<JavaType.FullyQualified> other$introspectableTypes = other.getIntrospectableTypes();
            return !(this$introspectableTypes == null ? other$introspectableTypes != null : !((Object)this$introspectableTypes).equals(other$introspectableTypes));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof Accumulator;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Set<JavaType.FullyQualified> $introspectableTypes = this.getIntrospectableTypes();
            result = result * 59 + ($introspectableTypes == null ? 43 : ((Object)$introspectableTypes).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "TypeRequiresIntrospection.Accumulator(introspectableTypes=" + this.getIntrospectableTypes() + ")";
        }
    }

    private static class AddIntrospectionAnnotationVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private static final String INTROSPECTED = "io.micronaut.core.annotation.Introspected";
        private static final AnnotationMatcher INTROSPECTION_ANNOTATION_MATCHER = new AnnotationMatcher("@io.micronaut.core.annotation.Introspected");
        final Set<JavaType.FullyQualified> introspectableTypes;

        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
            if (!this.introspectableTypes.contains(TypeUtils.asFullyQualified((JavaType)classDecl.getType()))) {
                return classDecl;
            }
            J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
            if (cd.getLeadingAnnotations().stream().noneMatch(arg_0 -> ((AnnotationMatcher)INTROSPECTION_ANNOTATION_MATCHER).matches(arg_0))) {
                this.maybeAddImport(INTROSPECTED);
                J.ClassDeclaration annotated = (J.ClassDeclaration)JavaTemplate.builder((String)"@Introspected").imports(new String[]{INTROSPECTED}).javaParser(JavaParser.fromJavaVersion().dependsOn(new String[]{"package io.micronaut.core.annotation; public @interface Introspected {}"})).build().apply(this.getCursor(), cd.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[0]);
                return (J.ClassDeclaration)this.maybeAutoFormat((J)classDecl, (J)annotated, (J)annotated.getName(), ctx, this.getCursor().getParentTreeCursor());
            }
            return cd;
        }

        @ConstructorProperties(value={"introspectableTypes"})
        @Generated
        public AddIntrospectionAnnotationVisitor(Set<JavaType.FullyQualified> introspectableTypes) {
            this.introspectableTypes = introspectableTypes;
        }
    }

    private static final class FindParamsAndReturnTypes
    extends JavaIsoVisitor<Set<JavaType.FullyQualified>> {
        private FindParamsAndReturnTypes() {
        }

        private void maybeAddType(// Could not load outer class - annotation placement on inner may be incorrect
        @Nullable JavaType.FullyQualified type, Set<JavaType.FullyQualified> foundTypes) {
            if (type != null && !TypeRequiresIntrospection.parentRequiresIntrospection(type)) {
                foundTypes.add(type);
            }
        }

        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, Set<JavaType.FullyQualified> foundTypes) {
            if (method.isConstructor()) {
                return method;
            }
            for (Statement param : method.getParameters()) {
                if (!(param instanceof J.VariableDeclarations)) continue;
                J.VariableDeclarations variableDeclarations = (J.VariableDeclarations)param;
                for (J.VariableDeclarations.NamedVariable namedVariable : variableDeclarations.getVariables()) {
                    if (namedVariable.getType() instanceof JavaType.Parameterized) {
                        for (JavaType type : ((JavaType.Parameterized)namedVariable.getType()).getTypeParameters()) {
                            this.maybeAddType(TypeUtils.asFullyQualified((JavaType)type), foundTypes);
                        }
                        continue;
                    }
                    this.maybeAddType(TypeUtils.asFullyQualified((JavaType)namedVariable.getType()), foundTypes);
                }
            }
            if (method.getReturnTypeExpression() instanceof J.ParameterizedType) {
                J.ParameterizedType parameterizedType = (J.ParameterizedType)method.getReturnTypeExpression();
                if (parameterizedType.getTypeParameters() != null) {
                    for (Expression typeParam : parameterizedType.getTypeParameters()) {
                        this.maybeAddType(TypeUtils.asFullyQualified((JavaType)typeParam.getType()), foundTypes);
                    }
                }
            } else if (method.getReturnTypeExpression() != null && method.getReturnTypeExpression().getType() != null) {
                this.maybeAddType(TypeUtils.asFullyQualified((JavaType)method.getReturnTypeExpression().getType()), foundTypes);
            }
            return method;
        }
    }
}

