/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.micronaut;

import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.micronaut.FindYamlConfig;
import org.openrewrite.yaml.CopyValue;
import org.openrewrite.yaml.DeleteKey;
import org.openrewrite.yaml.MergeYaml;
import org.openrewrite.yaml.cleanup.RemoveUnused;

public class UpdateSecurityYamlIfNeeded
extends Recipe {
    private final List<Recipe> recipeList = new ArrayList<Recipe>();
    private final String newYamlKeysSnippet = "generator:\n  access-token:\n    expiration:\ncookie:\n  enabled:\n  cookie-max-age:\n  cookie-path:\n  cookie-domain:\n  cookie-same-site:\nbearer:\n  enabled:";
    private static final String TOKEN_PATH = "$.micronaut.security.token";

    public String getDisplayName() {
        return "Update relocated Micronaut Security config yaml keys";
    }

    public String getDescription() {
        return "This recipe will update relocated security config keys in Micronaut configuration yaml files.";
    }

    public List<Recipe> getRecipeList() {
        return this.recipeList;
    }

    public UpdateSecurityYamlIfNeeded() {
        this.recipeList.add((Recipe)new MergeYaml(TOKEN_PATH, "generator:\n  access-token:\n    expiration:\ncookie:\n  enabled:\n  cookie-max-age:\n  cookie-path:\n  cookie-domain:\n  cookie-same-site:\nbearer:\n  enabled:", Boolean.TRUE, null, null));
        this.recipeList.add((Recipe)new CopyValue("$.micronaut.security.token.jwt.generator.access-token.expiration", null, "$.micronaut.security.token.generator.access-token.expiration", null));
        this.recipeList.add((Recipe)new CopyValue("$.micronaut.security.token.jwt.cookie.enabled", null, "$.micronaut.security.token.cookie.enabled", null));
        this.recipeList.add((Recipe)new CopyValue("$.micronaut.security.token.jwt.cookie.cookie-max-age", null, "$.micronaut.security.token.cookie.cookie-max-age", null));
        this.recipeList.add((Recipe)new CopyValue("$.micronaut.security.token.jwt.cookie.cookie-path", null, "$.micronaut.security.token.cookie.cookie-path", null));
        this.recipeList.add((Recipe)new CopyValue("$.micronaut.security.token.jwt.cookie.cookie-domain", null, "$.micronaut.security.token.cookie.cookie-domain", null));
        this.recipeList.add((Recipe)new CopyValue("$.micronaut.security.token.jwt.cookie.cookie-same-site", null, "$.micronaut.security.token.cookie.cookie-same-site", null));
        this.recipeList.add((Recipe)new CopyValue("$.micronaut.security.token.jwt.bearer.enabled", null, "$.micronaut.security.token.bearer.enabled", null));
        this.recipeList.add((Recipe)new DeleteKey("$.micronaut.security.token.jwt.generator", null));
        this.recipeList.add((Recipe)new DeleteKey("$.micronaut.security.token.jwt.cookie", null));
        this.recipeList.add((Recipe)new DeleteKey("$.micronaut.security.token.jwt.bearer", null));
        this.recipeList.add((Recipe)new RemoveUnused());
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.not(new FindYamlConfig().getVisitor()), (TreeVisitor)new TreeVisitor<Tree, ExecutionContext>(){

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (!UpdateSecurityYamlIfNeeded.this.recipeList.isEmpty()) {
                    UpdateSecurityYamlIfNeeded.this.recipeList.clear();
                }
                return super.visit(tree, (Object)ctx);
            }
        });
    }
}

