/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.micronaut;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.AddDependency;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.search.FindProperties;
import org.openrewrite.xml.tree.Xml;

public class AddTestResourcesClientDependencyIfNeeded
extends ScanningRecipe<Scanned> {
    private final List<Recipe> recipeList = new ArrayList<Recipe>();

    public AddTestResourcesClientDependencyIfNeeded() {
        this.recipeList.add((Recipe)new AddDependency("io.micronaut.testresources", "micronaut-test-resources-client", "LATEST", null, "provided", null, "io.micronaut.runtime.Micronaut", null, null, null, null, null));
    }

    public String getDisplayName() {
        return "Add Test Resources Client dependency if needed";
    }

    public String getDescription() {
        return "This recipe adds the Test Resources Client dependency to pom.xml if test.resources.client.enabled property is true.";
    }

    public List<Recipe> getRecipeList() {
        return this.recipeList;
    }

    public Scanned getInitialValue(ExecutionContext ctx) {
        return new Scanned();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Scanned acc) {
        return new MavenIsoVisitor<ExecutionContext>(){

            public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
                Xml.Document maven = super.visitDocument(document, (Object)ctx);
                Optional testResourcesProp = FindProperties.find((Xml.Document)document, (String)"micronaut\\.test\\.resources\\.enabled").stream().findFirst();
                if ("true".equals(testResourcesProp.flatMap(Xml.Tag::getValue).orElse("false"))) {
                    acc.isTestResourcesEnabled = true;
                }
                return maven;
            }
        };
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(Scanned acc) {
        return Preconditions.check((!acc.isTestResourcesEnabled ? 1 : 0) != 0, (TreeVisitor)new TreeVisitor<Tree, ExecutionContext>(){

            @Nullable
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (!AddTestResourcesClientDependencyIfNeeded.this.recipeList.isEmpty()) {
                    AddTestResourcesClientDependencyIfNeeded.this.recipeList.clear();
                }
                return super.visit(tree, (Object)ctx);
            }
        });
    }

    static class Scanned {
        boolean isTestResourcesEnabled;

        Scanned() {
        }
    }
}

