/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.micronaut;

import java.util.ArrayList;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.micronaut.FindPropertiesConfig;
import org.openrewrite.properties.ChangePropertyKey;

public class UpdateSecurityPropertiesIfNeeded
extends Recipe {
    private final List<Recipe> recipeList = new ArrayList<Recipe>();

    public String getDisplayName() {
        return "Update relocated Micronaut Security config properties";
    }

    public String getDescription() {
        return "This recipe will update relocated security config keys in Micronaut configuration property files.";
    }

    public List<Recipe> getRecipeList() {
        return this.recipeList;
    }

    public UpdateSecurityPropertiesIfNeeded() {
        this.recipeList.add((Recipe)new ChangePropertyKey("micronaut.security.token.jwt.generator.access-token.expiration", "micronaut.security.token.generator.access-token.expiration", null, null));
        this.recipeList.add((Recipe)new ChangePropertyKey("micronaut.security.token.jwt.cookie.enabled", "micronaut.security.token.cookie.enabled", null, null));
        this.recipeList.add((Recipe)new ChangePropertyKey("micronaut.security.token.jwt.cookie.cookie-max-age", "micronaut.security.token.cookie.cookie-max-age", null, null));
        this.recipeList.add((Recipe)new ChangePropertyKey("micronaut.security.token.jwt.cookie.cookie-path", "micronaut.security.token.cookie.cookie-path", null, null));
        this.recipeList.add((Recipe)new ChangePropertyKey("micronaut.security.token.jwt.cookie.cookie-domain", "micronaut.security.token.cookie.cookie-domain", null, null));
        this.recipeList.add((Recipe)new ChangePropertyKey("micronaut.security.token.jwt.cookie.cookie-same-site", "micronaut.security.token.cookie.cookie-same-site", null, null));
        this.recipeList.add((Recipe)new ChangePropertyKey("micronaut.security.token.jwt.bearer.enabled", "micronaut.security.token.bearer.enabled", null, null));
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.not(new FindPropertiesConfig().getVisitor()), (TreeVisitor)new TreeVisitor<Tree, ExecutionContext>(){

            @Nullable
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (!UpdateSecurityPropertiesIfNeeded.this.recipeList.isEmpty()) {
                    UpdateSecurityPropertiesIfNeeded.this.recipeList.clear();
                }
                return super.visit(tree, (Object)ctx);
            }
        });
    }
}

