/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.micronaut;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.ChangeLiteral;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class BeanPropertyCapitalizationStrategy
extends Recipe {
    public String getDisplayName() {
        return "De-capitalize `BeanIntrospection` `getProperty(..)` and `getRequiredProperty(..)` name arguments";
    }

    public String getDescription() {
        return "As of Micronaut 3.x property names for getters like `getXForwarded()` are de-capitalized from `XForwarded` to `xForwarded`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("io.micronaut.core.beans.BeanIntrospection", Boolean.valueOf(false)), (TreeVisitor)new BeanPropertyCapitalizationStrategyVisitor());
    }

    private static class BeanPropertyCapitalizationStrategyVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private static final MethodMatcher BEAN_PROPERTY_METHOD = new MethodMatcher("io.micronaut.core.beans.BeanIntrospection getProperty(..)");
        private static final MethodMatcher REQUIRED_BEAN_PROPERTY_METHOD = new MethodMatcher("io.micronaut.core.beans.BeanIntrospection getRequiredProperty(..)");

        private BeanPropertyCapitalizationStrategyVisitor() {
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            String newValue;
            J.Literal propertyNameArg;
            String sVal;
            J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
            if ((BEAN_PROPERTY_METHOD.matches((MethodCall)mi) || REQUIRED_BEAN_PROPERTY_METHOD.matches((MethodCall)mi)) && mi.getArguments().get(0) instanceof J.Literal && !(sVal = String.valueOf((propertyNameArg = (J.Literal)mi.getArguments().get(0)).getValue())).equals(newValue = sVal.substring(0, 1).toLowerCase() + sVal.substring(1))) {
                this.doAfterVisit((TreeVisitor)new ChangeLiteral((Expression)propertyNameArg, p -> newValue));
            }
            return mi;
        }
    }
}

