/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.micronaut;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class CopyNonInheritedAnnotations
extends ScanningRecipe<Accumulator> {
    private static final Set<String> NON_INHERITED_ANNOTATION_TYPES = Stream.of("io.micronaut.aop.Around", "io.micronaut.aop.AroundConstruct", "io.micronaut.aop.InterceptorBean", "io.micronaut.aop.InterceptorBinding", "io.micronaut.aop.Introduction", "io.micronaut.core.annotation.Creator", "io.micronaut.core.annotation.Experimental", "io.micronaut.core.annotation.Nullable", "io.micronaut.core.annotation.NonNull", "io.micronaut.core.annotation.Order", "io.micronaut.core.annotation.ReflectiveAccess", "io.micronaut.core.annotation.TypeHint", "io.micronaut.core.version.annotation.Version", "io.micronaut.context.annotation.AliasFor", "io.micronaut.context.annotation.Any", "io.micronaut.context.annotation.Bean", "io.micronaut.context.annotation.ConfigurationBuilder", "io.micronaut.context.annotation.ConfigurationInject", "io.micronaut.context.annotation.ConfigurationProperties", "io.micronaut.context.annotation.ConfigurationReader", "io.micronaut.context.annotation.Context", "io.micronaut.context.annotation.DefaultScope", "io.micronaut.context.annotation.EachBean", "io.micronaut.context.annotation.Factory", "io.micronaut.context.annotation.NonBinding", "io.micronaut.context.annotation.Parallel", "io.micronaut.context.annotation.Parameter", "io.micronaut.context.annotation.Primary", "io.micronaut.context.annotation.Property", "io.micronaut.context.annotation.PropertySource", "io.micronaut.context.annotation.Prototype", "io.micronaut.context.annotation.Replaces", "io.micronaut.context.annotation.Requirements", "io.micronaut.context.annotation.Requires", "io.micronaut.context.annotation.Secondary", "io.micronaut.context.annotation.Type", "io.micronaut.context.annotation.Value", "io.micronaut.context.annotation.Controller", "io.micronaut.http.annotation.Filter", "io.micronaut.http.annotation.FilterMatcher", "io.micronaut.http.client.annotation.Client", "io.micronaut.jackson.annotation.JacksonFeatures", "io.micronaut.management.endpoint.annotation.EndPont", "io.micronaut.management.health.indicator.annotation.Liveness", "io.micronaut.management.health.indicator.annotation.Readiness", "io.micronaut.messaging.annotation.MessageListener", "io.micronaut.messaging.annotation.MessageProducer", "io.micronaut.retry.annotation.CircuitBreaker", "io.micronaut.retry.annotation.Fallback", "io.micronaut.retry.annotation.Recoverable", "io.micronaut.retry.annotation.Retryable", "io.micronaut.runtime.context.scope.Refreshable", "io.micronaut.runtime.context.scope.ScopedProxy", "io.micronaut.runtime.context.scope.ThreadLocal", "io.micronaut.runtime.http.scope.RequestScope", "io.micronaut.scheduling.annotation.Async", "io.micronaut.scheduling.annotation.ExecuteOn", "io.micronaut.scheduling.annotation.Scheduled", "io.micronaut.websocket.annotation.ClientWebSocket", "io.micronaut.websocket.annotation.ServerWebSocket", "io.micronaut.websocket.annotation.WebSocketComponent").collect(Collectors.toSet());

    public String getDisplayName() {
        return "Copy non-inherited annotations from super class";
    }

    public String getDescription() {
        return "As of Micronaut 3.x only [annotations](https://github.com/micronaut-projects/micronaut-core/blob/3.0.x/src/main/docs/guide/appendix/breaks.adoc#annotation-inheritance) that are explicitly meta-annotated with `@Inherited` are inherited from parent classes and interfaces.";
    }

    public Accumulator getInitialValue(ExecutionContext ctx) {
        return new Accumulator();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Accumulator acc) {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
                if (cd.getType() != null) {
                    String classFqn = cd.getType().getFullyQualifiedName();
                    for (J.Annotation annotation : cd.getLeadingAnnotations()) {
                        JavaType.FullyQualified annoFq = TypeUtils.asFullyQualified((JavaType)annotation.getType());
                        if (annoFq == null || !NON_INHERITED_ANNOTATION_TYPES.stream().anyMatch(fqn -> fqn.equals(annoFq.getFullyQualifiedName()))) continue;
                        acc.getParentAnnotationsByType().computeIfAbsent(classFqn, v -> new ArrayList()).add(annotation);
                    }
                }
                return cd;
            }
        };
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(Accumulator acc) {
        if (acc.getParentAnnotationsByType().isEmpty()) {
            return TreeVisitor.noop();
        }
        final CopyAnnoVisitor copyAnnoVisitor = new CopyAnnoVisitor(acc.getParentAnnotationsByType());
        return new TreeVisitor<Tree, ExecutionContext>(){

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof J.CompilationUnit) {
                    return copyAnnoVisitor.visit(tree, ctx);
                }
                return tree;
            }
        };
    }

    static class Accumulator {
        final Map<String, List<J.Annotation>> parentAnnotationsByType = new HashMap<String, List<J.Annotation>>();

        @Generated
        public Accumulator() {
        }

        @Generated
        public Map<String, List<J.Annotation>> getParentAnnotationsByType() {
            return this.parentAnnotationsByType;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Accumulator)) {
                return false;
            }
            Accumulator other = (Accumulator)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, List<J.Annotation>> this$parentAnnotationsByType = this.getParentAnnotationsByType();
            Map<String, List<J.Annotation>> other$parentAnnotationsByType = other.getParentAnnotationsByType();
            return !(this$parentAnnotationsByType == null ? other$parentAnnotationsByType != null : !((Object)this$parentAnnotationsByType).equals(other$parentAnnotationsByType));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof Accumulator;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, List<J.Annotation>> $parentAnnotationsByType = this.getParentAnnotationsByType();
            result = result * 59 + ($parentAnnotationsByType == null ? 43 : ((Object)$parentAnnotationsByType).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "CopyNonInheritedAnnotations.Accumulator(parentAnnotationsByType=" + this.getParentAnnotationsByType() + ")";
        }
    }

    private static final class CopyAnnoVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final Map<String, List<J.Annotation>> parentAnnotationsByType;

        private CopyAnnoVisitor(Map<String, List<J.Annotation>> parentAnnotationsByType) {
            this.parentAnnotationsByType = parentAnnotationsByType;
        }

        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
            J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
            HashSet<String> parentTypes = new HashSet<String>();
            JavaType.FullyQualified currentFq = cd.getType();
            while (currentFq != null) {
                parentTypes.add(currentFq.getFullyQualifiedName());
                for (JavaType.FullyQualified i : currentFq.getInterfaces()) {
                    parentTypes.add(i.getFullyQualifiedName());
                }
                if ((currentFq = currentFq.getSupertype()) == null || !parentTypes.contains(currentFq.getFullyQualifiedName())) continue;
            }
            HashSet<String> existingAnnotations = new HashSet<String>();
            for (Object leadingAnnotation : cd.getLeadingAnnotations()) {
                JavaType.FullyQualified fullyQualified = TypeUtils.asFullyQualified((JavaType)leadingAnnotation.getType());
                if (fullyQualified == null) continue;
                existingAnnotations.add(fullyQualified.getFullyQualifiedName());
            }
            ArrayList<J.Annotation> annotationsFromParentClass = new ArrayList<J.Annotation>();
            for (String parentTypeFq : parentTypes) {
                List<J.Annotation> parentAnnotations = this.parentAnnotationsByType.get(parentTypeFq);
                if (parentAnnotations == null) continue;
                for (J.Annotation annotation : parentAnnotations) {
                    JavaType.FullyQualified annotationName = TypeUtils.asFullyQualified((JavaType)annotation.getType());
                    if (annotationName == null || existingAnnotations.contains(annotationName.getFullyQualifiedName())) continue;
                    annotationsFromParentClass.add(annotation);
                    existingAnnotations.add(annotationName.getFullyQualifiedName());
                }
            }
            List afterAnnotationList = ListUtils.concatAll((List)cd.getLeadingAnnotations(), annotationsFromParentClass);
            if (afterAnnotationList != cd.getLeadingAnnotations()) {
                cd = cd.withLeadingAnnotations(afterAnnotationList);
                cd = (J.ClassDeclaration)this.autoFormat((J)cd, (J)cd.getName(), ctx, this.getCursor());
                for (J.Annotation annotation : annotationsFromParentClass) {
                    JavaType.FullyQualified fullyQualified = TypeUtils.asFullyQualified((JavaType)annotation.getType());
                    if (fullyQualified == null) continue;
                    this.maybeAddImport(fullyQualified.getFullyQualifiedName());
                }
            }
            return cd;
        }
    }
}

