/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.micronaut;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.xml.FilterTagChildrenVisitor;
import org.openrewrite.xml.MapTagChildrenVisitor;
import org.openrewrite.xml.tree.Xml;

public final class RemoveAnnotationProcessorPath
extends Recipe {
    @Option(displayName="GroupId", description="The groupId to use.", example="corp.internal.openrewrite.recipe")
    private final String groupId;
    @Option(displayName="ArtifactId", description="The artifactId to use.", example="my-new-annotation-processor")
    private final String artifactId;

    public String getDisplayName() {
        return "Remove Maven annotation processor path";
    }

    public String getDescription() {
        return "Remove the Maven annotation processor path that matches the given groupId and artifactId.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){

            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag plugin = super.visitTag(tag, (Object)ctx);
                if (this.isPluginTag("org.apache.maven.plugins", "maven-compiler-plugin") && (plugin = this.maybeUpdatePlugin(plugin)) != tag) {
                    this.maybeUpdateModel();
                }
                return plugin;
            }

            private Xml.Tag maybeUpdatePlugin(Xml.Tag plugin) {
                return MapTagChildrenVisitor.mapTagChildren((Xml.Tag)plugin, childTag -> "configuration".equals(childTag.getName()) ? this.maybeUpdateConfiguration((Xml.Tag)childTag) : childTag);
            }

            private Xml.Tag maybeUpdateConfiguration(Xml.Tag configuration) {
                return MapTagChildrenVisitor.mapTagChildren((Xml.Tag)configuration, childTag -> "annotationProcessorPaths".equals(childTag.getName()) ? this.maybeUpdateAnnotationProcessorPaths((Xml.Tag)childTag) : childTag);
            }

            private Xml.Tag maybeUpdateAnnotationProcessorPaths(Xml.Tag annotationProcessorPaths) {
                return FilterTagChildrenVisitor.filterTagChildren((Xml.Tag)annotationProcessorPaths, childTag -> !"path".equals(childTag.getName()) || !this.isPathMatch((Xml.Tag)childTag));
            }

            private boolean isPathMatch(Xml.Tag path) {
                return RemoveAnnotationProcessorPath.this.groupId.equals(path.getChildValue("groupId").orElse(null)) && RemoveAnnotationProcessorPath.this.artifactId.equals(path.getChildValue("artifactId").orElse(null));
            }
        };
    }

    @ConstructorProperties(value={"groupId", "artifactId"})
    @Generated
    public RemoveAnnotationProcessorPath(String groupId, String artifactId) {
        this.groupId = groupId;
        this.artifactId = artifactId;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getArtifactId() {
        return this.artifactId;
    }

    @NonNull
    @Generated
    public String toString() {
        return "RemoveAnnotationProcessorPath(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveAnnotationProcessorPath)) {
            return false;
        }
        RemoveAnnotationProcessorPath other = (RemoveAnnotationProcessorPath)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        return !(this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RemoveAnnotationProcessorPath;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        return result;
    }
}

