/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.javax;

import java.util.Comparator;
import java.util.regex.Pattern;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;

public final class AddTransientAnnotationToCollections
extends Recipe {
    public String getDisplayName() {
        return "Unannotated collection attributes require a Transient annotation";
    }

    public String getDescription() {
        return "In OpenJPA, attributes that inherit from the `java.util.Collection<E>` interface are not a default persistent type, so these attributes are not persisted unless they are annotated. EclipseLink has a different default behavior and attempts to persist these attributes to the database. To keep the OpenJPA behavior of ignoring unannotated collection attributes, add the `javax.persistence.Transient` annotation to these attributes in EclipseLink.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final Pattern collection = Pattern.compile("java.util.Collection");
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("javax.persistence.Entity", Boolean.valueOf(true)), new UsesType("javax.persistence.MappedSuperclass", Boolean.valueOf(true)), new UsesType("javax.persistence.Embeddable", Boolean.valueOf(true))}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
                if (!multiVariable.getType().isAssignableFrom(collection)) {
                    return multiVariable;
                }
                if (multiVariable.getLeadingAnnotations().stream().anyMatch(anno -> anno.getType().toString().contains("javax.persistence"))) {
                    return multiVariable;
                }
                this.maybeAddImport("javax.persistence.Transient");
                return (J.VariableDeclarations)JavaTemplate.builder((String)"@Transient").contextSensitive().javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"javax.persistence-api-2.2"})).imports(new String[]{"javax.persistence.Transient"}).build().apply(this.getCursor(), multiVariable.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[0]);
            }
        });
    }

    @NonNull
    public String toString() {
        return "AddTransientAnnotationToCollections()";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddTransientAnnotationToCollections)) {
            return false;
        }
        AddTransientAnnotationToCollections other = (AddTransientAnnotationToCollections)((Object)o);
        return other.canEqual((Object)this);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddTransientAnnotationToCollections;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

