/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate;

import com.fasterxml.jackson.annotation.JsonCreator;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public final class ReplaceLocalizedStreamMethods
extends Recipe {
    @Option(displayName="Method pattern to replace", description="The method pattern to match and replace.", example="java.lang.Runtime getLocalizedInputStream(java.io.InputStream)")
    private final String localizedInputStreamMethodMatcher;
    @Option(displayName="Method pattern to replace", description="The method pattern to match and replace.", example="java.lang.Runtime getLocalizedOutputStream(java.io.OutputStream)")
    private final String localizedOutputStreamMethodMatcher;

    @JsonCreator
    public ReplaceLocalizedStreamMethods(@Nullable String localizedInputStreamMethodMatcher, @Nullable String localizedOutputStreamMethodMatcher) {
        this.localizedInputStreamMethodMatcher = localizedInputStreamMethodMatcher == null ? "java.lang.Runtime getLocalizedInputStream(java.io.InputStream)" : localizedInputStreamMethodMatcher;
        this.localizedOutputStreamMethodMatcher = localizedOutputStreamMethodMatcher == null ? "java.lang.Runtime getLocalizedOutputStream(java.io.OutputStream)" : localizedOutputStreamMethodMatcher;
    }

    public String getDisplayName() {
        return "Replace `getLocalizedInputStream` and `getLocalizedOutputStream` with direct assignment";
    }

    public String getDescription() {
        return "Replaces `Runtime.getLocalizedInputStream(InputStream)` and `Runtime.getLocalizedOutputStream(OutputStream)` with their direct arguments. This modification is made because the previous implementation of `getLocalizedInputStream` and `getLocalizedOutputStream` merely returned the arguments provided.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){
            private final MethodMatcher LocalizedInputStreamMethod;
            private final MethodMatcher localizedOutputStreamMethod;
            {
                this.LocalizedInputStreamMethod = new MethodMatcher(ReplaceLocalizedStreamMethods.this.localizedInputStreamMethodMatcher, false);
                this.localizedOutputStreamMethod = new MethodMatcher(ReplaceLocalizedStreamMethods.this.localizedOutputStreamMethodMatcher, false);
            }

            public J visitMethodInvocation(J.MethodInvocation mi, ExecutionContext ctx) {
                if (this.LocalizedInputStreamMethod.matches((MethodCall)mi) || this.localizedOutputStreamMethod.matches((MethodCall)mi)) {
                    return ((Expression)mi.getArguments().get(0)).withPrefix(mi.getPrefix());
                }
                return super.visitMethodInvocation(mi, (Object)ctx);
            }
        };
    }

    @Generated
    public String getLocalizedInputStreamMethodMatcher() {
        return this.localizedInputStreamMethodMatcher;
    }

    @Generated
    public String getLocalizedOutputStreamMethodMatcher() {
        return this.localizedOutputStreamMethodMatcher;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ReplaceLocalizedStreamMethods(localizedInputStreamMethodMatcher=" + this.getLocalizedInputStreamMethodMatcher() + ", localizedOutputStreamMethodMatcher=" + this.getLocalizedOutputStreamMethodMatcher() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReplaceLocalizedStreamMethods)) {
            return false;
        }
        ReplaceLocalizedStreamMethods other = (ReplaceLocalizedStreamMethods)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$localizedInputStreamMethodMatcher = this.getLocalizedInputStreamMethodMatcher();
        String other$localizedInputStreamMethodMatcher = other.getLocalizedInputStreamMethodMatcher();
        if (this$localizedInputStreamMethodMatcher == null ? other$localizedInputStreamMethodMatcher != null : !this$localizedInputStreamMethodMatcher.equals(other$localizedInputStreamMethodMatcher)) {
            return false;
        }
        String this$localizedOutputStreamMethodMatcher = this.getLocalizedOutputStreamMethodMatcher();
        String other$localizedOutputStreamMethodMatcher = other.getLocalizedOutputStreamMethodMatcher();
        return !(this$localizedOutputStreamMethodMatcher == null ? other$localizedOutputStreamMethodMatcher != null : !this$localizedOutputStreamMethodMatcher.equals(other$localizedOutputStreamMethodMatcher));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof ReplaceLocalizedStreamMethods;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $localizedInputStreamMethodMatcher = this.getLocalizedInputStreamMethodMatcher();
        result = result * 59 + ($localizedInputStreamMethodMatcher == null ? 43 : $localizedInputStreamMethodMatcher.hashCode());
        String $localizedOutputStreamMethodMatcher = this.getLocalizedOutputStreamMethodMatcher();
        result = result * 59 + ($localizedOutputStreamMethodMatcher == null ? 43 : $localizedOutputStreamMethodMatcher.hashCode());
        return result;
    }
}

