/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.migrate.SharedDataHolder;
import org.openrewrite.xml.AddOrUpdateChild;
import org.openrewrite.xml.FilterTagChildrenVisitor;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.XmlVisitor;
import org.openrewrite.xml.tree.Xml;

class PersistenceXmlVisitor
extends XmlVisitor<ExecutionContext> {
    private static final XPathMatcher PERSISTENCE_MATCHER = new XPathMatcher("/persistence");
    private static final String SHARED_CACHE_MODE_VALUE_UNSPECIFIED = "UNSPECIFIED";

    PersistenceXmlVisitor() {
    }

    public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
        String attrValue;
        String scmValue;
        Xml.Tag t = (Xml.Tag)super.visitTag(tag, (Object)ctx);
        if (!"persistence-unit".equals(t.getName())) {
            return t;
        }
        SharedDataHolder sdh = this.extractData(t);
        if (!sdh.shouldFlag()) {
            return t;
        }
        String version = null;
        if (PERSISTENCE_MATCHER.matches(this.getCursor())) {
            for (Xml.Attribute attribute : t.getAttributes()) {
                if (!"version".equals(attribute.getKeyAsString())) continue;
                version = attribute.getValue().getValue();
            }
        }
        boolean v1 = "1.0".equals(version);
        if (sdh.sharedCacheModeElement != null || sdh.sharedCacheModeProperty != null) {
            if (sdh.sharedCacheModeElement != null && sdh.sharedCacheModeElementUnspecified) {
                scmValue = "NONE";
                if (sdh.openJPACacheProperty != null) {
                    String propVal = this.getAttributeValue("value", sdh.openJPACacheProperty);
                    scmValue = this.interpretOpenJPAPropertyValue(propVal);
                }
                String sharedCacheModeElementOriginal = this.getTextContent(sdh.sharedCacheModeElement);
                String newValue = sharedCacheModeElementOriginal.replaceFirst(SHARED_CACHE_MODE_VALUE_UNSPECIFIED, scmValue);
                sdh.sharedCacheModeElement = sdh.sharedCacheModeElement.withValue(newValue);
                t = AddOrUpdateChild.addOrUpdateChild((Xml.Tag)t, (Xml.Tag)sdh.sharedCacheModeElement, (Cursor)this.getCursor().getParentOrThrow());
            } else if (sdh.sharedCacheModeProperty != null && sdh.sharedCacheModePropertyUnspecified) {
                scmValue = "NONE";
                if (sdh.openJPACacheProperty != null) {
                    String propVal = this.getAttributeValue("value", sdh.openJPACacheProperty);
                    scmValue = this.interpretOpenJPAPropertyValue(propVal);
                }
                Xml.Tag updatedProp = this.updateAttributeValue("value", scmValue, sdh.sharedCacheModeProperty);
                sdh.propertiesElement = sdh.propertiesElement.withContent(ListUtils.map((List)sdh.propertiesElement.getContent(), content -> content == sdh.sharedCacheModeProperty ? updatedProp : content));
                sdh.sharedCacheModeProperty = updatedProp;
                t = AddOrUpdateChild.addOrUpdateChild((Xml.Tag)t, (Xml.Tag)sdh.propertiesElement, (Cursor)this.getCursor().getParentOrThrow());
            }
        } else {
            if (sdh.openJPACacheProperty == null) {
                scmValue = "NONE";
            } else {
                String propVal = this.getAttributeValue("value", sdh.openJPACacheProperty);
                scmValue = this.interpretOpenJPAPropertyValue(propVal);
            }
            if (scmValue != null) {
                if (!v1) {
                    Xml.Tag newNode = Xml.Tag.build((String)("<shared-cache-mode>" + scmValue + "</shared-cache-mode>"));
                    Cursor parent = this.getCursor().getParentOrThrow();
                    t = (Xml.Tag)this.autoFormat((Xml)AddOrUpdateChild.addOrUpdateChild((Xml.Tag)t, (Xml.Tag)newNode, (Cursor)parent), ctx, parent);
                } else {
                    String eclipseLinkPropValue = this.convertScmValue(scmValue);
                    if (eclipseLinkPropValue != null) {
                        if (sdh.propertiesElement == null) {
                            sdh.propertiesElement = Xml.Tag.build((String)"<properties></properties>");
                        }
                        Xml.Tag newElement = Xml.Tag.build((String)("<property name=\"eclipselink.cache.shared.default\" value=\"" + eclipseLinkPropValue + "\"></property>"));
                        sdh.propertiesElement = AddOrUpdateChild.addOrUpdateChild((Xml.Tag)sdh.propertiesElement, (Xml.Tag)newElement, (Cursor)this.getCursor().getParentOrThrow());
                        t = AddOrUpdateChild.addOrUpdateChild((Xml.Tag)t, (Xml.Tag)sdh.propertiesElement, (Cursor)this.getCursor().getParentOrThrow());
                    }
                }
            }
        }
        if (sdh.openJPACacheProperty != null && ("true".equalsIgnoreCase(attrValue = this.getAttributeValue("value", sdh.openJPACacheProperty)) || "false".equalsIgnoreCase(attrValue))) {
            sdh.propertiesElement = FilterTagChildrenVisitor.filterTagChildren((Xml.Tag)sdh.propertiesElement, child -> child != sdh.openJPACacheProperty);
            t = AddOrUpdateChild.addOrUpdateChild((Xml.Tag)t, (Xml.Tag)sdh.propertiesElement, (Cursor)this.getCursor().getParentOrThrow());
        }
        if (sdh.sharedCacheModeElement != null && sdh.sharedCacheModeProperty != null) {
            sdh.propertiesElement = FilterTagChildrenVisitor.filterTagChildren((Xml.Tag)sdh.propertiesElement, child -> child != sdh.sharedCacheModeProperty);
            t = AddOrUpdateChild.addOrUpdateChild((Xml.Tag)t, (Xml.Tag)sdh.propertiesElement, (Cursor)this.getCursor().getParentOrThrow());
        }
        return t;
    }

    private SharedDataHolder extractData(Xml.Tag puNode) {
        SharedDataHolder sdh = new SharedDataHolder();
        sdh.sharedCacheModeElement = puNode.getChild("shared-cache-mode").orElse(null);
        this.getDataCacheProps(puNode, sdh);
        sdh.sharedCacheModeElementUnspecified = sdh.sharedCacheModeElement != null && SHARED_CACHE_MODE_VALUE_UNSPECIFIED.equals(this.getTextContent(sdh.sharedCacheModeElement));
        sdh.sharedCacheModePropertyUnspecified = sdh.sharedCacheModeProperty != null && SHARED_CACHE_MODE_VALUE_UNSPECIFIED.equals(this.getAttributeValue("value", sdh.sharedCacheModeProperty));
        return sdh;
    }

    private @Nullable String getAttributeValue(String attrName, Xml.Tag node) {
        for (Xml.Attribute attribute : node.getAttributes()) {
            if (!attribute.getKeyAsString().equals(attrName)) continue;
            return attribute.getValue().getValue();
        }
        return null;
    }

    private Xml.Tag updateAttributeValue(String attrName, String newValue, Xml.Tag node) {
        ArrayList<Xml.Attribute> updatedAttributes = new ArrayList<Xml.Attribute>();
        for (Xml.Attribute attribute : node.getAttributes()) {
            if (attribute.getKeyAsString().equals(attrName)) {
                attribute = attribute.withValue(new Xml.Attribute.Value(attribute.getId(), "", attribute.getMarkers(), attribute.getValue().getQuote(), newValue));
                updatedAttributes.add(attribute);
                continue;
            }
            updatedAttributes.add(attribute);
        }
        return node.withAttributes(updatedAttributes);
    }

    private void getDataCacheProps(Xml.Tag puNode, SharedDataHolder sdh) {
        Optional propertiesTag = puNode.getChild("properties");
        if (propertiesTag.isPresent()) {
            sdh.propertiesElement = (Xml.Tag)propertiesTag.get();
            List properties = sdh.propertiesElement.getChildren("property");
            for (Xml.Tag prop : properties) {
                String name = this.getAttributeValue("name", prop);
                if (name == null) continue;
                if ("openjpa.DataCache".equals(name)) {
                    sdh.openJPACacheProperty = prop;
                    continue;
                }
                if ("javax.persistence.sharedCache.mode".equals(name)) {
                    sdh.sharedCacheModeProperty = prop;
                    continue;
                }
                if (!"eclipselink.cache.shared.default".equals(name)) continue;
                sdh.eclipselinkCacheProperty = prop;
            }
        }
    }

    private @Nullable String getTextContent(// Could not load outer class - annotation placement on inner may be incorrect
    @Nullable Xml.Tag node) {
        if (node != null) {
            String textContent = null;
            Optional optionalValue = node.getValue();
            if (optionalValue.isPresent()) {
                textContent = (String)optionalValue.get();
            }
            return textContent;
        }
        return null;
    }

    private @Nullable String interpretOpenJPAPropertyValue(@Nullable String propVal) {
        if (propVal != null) {
            if ("false".equalsIgnoreCase(propVal)) {
                return "NONE";
            }
            if ("true".equalsIgnoreCase(propVal)) {
                return "ALL";
            }
            if (propVal.matches("(?i:true)\\(ExcludedTypes=.*")) {
                return "DISABLE_SELECTIVE";
            }
            if (propVal.matches("(?i:true)\\(Types=.*")) {
                return "ENABLE_SELECTIVE";
            }
        }
        return null;
    }

    private @Nullable String convertScmValue(String scmValue) {
        if ("NONE".equals(scmValue)) {
            return "false";
        }
        if ("ALL".equals(scmValue)) {
            return "true";
        }
        return null;
    }
}

