/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.joda;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.migrate.joda.ScopeAwareVisitor;
import org.openrewrite.java.migrate.joda.templates.AllTemplates;
import org.openrewrite.java.migrate.joda.templates.MethodTemplate;
import org.openrewrite.java.migrate.joda.templates.TimeClassMap;
import org.openrewrite.java.migrate.joda.templates.TimeClassNames;
import org.openrewrite.java.migrate.joda.templates.VarTemplates;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public class JodaTimeVisitor
extends ScopeAwareVisitor {
    private final Set<J.VariableDeclarations.NamedVariable> unsafeVars;

    public JodaTimeVisitor(Set<J.VariableDeclarations.NamedVariable> unsafeVars, LinkedList<ScopeAwareVisitor.VariablesInScope> scopes) {
        super(scopes);
        this.unsafeVars = unsafeVars;
    }

    public JodaTimeVisitor(Set<J.VariableDeclarations.NamedVariable> unsafeVars) {
        this(unsafeVars, new LinkedList<ScopeAwareVisitor.VariablesInScope>());
    }

    public JodaTimeVisitor() {
        this(new HashSet<J.VariableDeclarations.NamedVariable>());
    }

    @NonNull
    public J visitCompilationUnit(@NonNull J.CompilationUnit cu, @NonNull ExecutionContext ctx) {
        if (cu == null) {
            throw new NullPointerException("cu is marked non-null but is null");
        }
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        this.maybeRemoveImport("org.joda.time.DateTime");
        this.maybeRemoveImport("org.joda.time.DateTimeZone");
        this.maybeRemoveImport("org.joda.time.format.DateTimeFormat");
        this.maybeRemoveImport("org.joda.time.Duration");
        this.maybeRemoveImport("org.joda.time.base.AbstractInstant");
        this.maybeRemoveImport("org.joda.time.Instant");
        this.maybeRemoveImport("java.util.Locale");
        this.maybeAddImport("java.time.ZonedDateTime");
        this.maybeAddImport("java.time.ZoneOffset");
        this.maybeAddImport("java.time.ZoneId");
        this.maybeAddImport("java.time.Instant");
        this.maybeAddImport("java.time.format.DateTimeFormatter");
        this.maybeAddImport("java.time.format.FormatStyle");
        this.maybeAddImport("java.time.Duration");
        this.maybeAddImport("java.time.LocalDate");
        this.maybeAddImport("java.time.LocalTime");
        this.maybeAddImport("java.time.temporal.IsoFields");
        this.maybeAddImport("java.time.temporal.ChronoField");
        this.maybeAddImport("java.util.Date");
        return super.visitCompilationUnit(cu, (Object)ctx);
    }

    @NonNull
    public J visitVariableDeclarations(@NonNull J.VariableDeclarations multiVariable, @NonNull ExecutionContext ctx) {
        if (multiVariable == null) {
            throw new NullPointerException("multiVariable is marked non-null but is null");
        }
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        if (!multiVariable.getType().isAssignableFrom(TimeClassNames.JODA_CLASS_PATTERN)) {
            return super.visitVariableDeclarations(multiVariable, (Object)ctx);
        }
        if (multiVariable.getVariables().stream().anyMatch(this.unsafeVars::contains)) {
            return multiVariable;
        }
        multiVariable = (J.VariableDeclarations)super.visitVariableDeclarations(multiVariable, (Object)ctx);
        return VarTemplates.getTemplate(multiVariable).apply(this.updateCursor((Tree)multiVariable), multiVariable.getCoordinates().replace(), VarTemplates.getTemplateArgs(multiVariable));
    }

    @NonNull
    public J visitVariable(@NonNull J.VariableDeclarations.NamedVariable variable, @NonNull ExecutionContext ctx) {
        if (variable == null) {
            throw new NullPointerException("variable is marked non-null but is null");
        }
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        if (!variable.getType().isAssignableFrom(TimeClassNames.JODA_CLASS_PATTERN)) {
            return super.visitVariable(variable, (Object)ctx);
        }
        if (this.unsafeVars.contains(variable) || !(variable.getType() instanceof JavaType.Class)) {
            return variable;
        }
        JavaType.Class jodaType = (JavaType.Class)variable.getType();
        return variable.withType((JavaType)TimeClassMap.getJavaTimeType(jodaType.getFullyQualifiedName())).withInitializer((Expression)this.visit((Tree)variable.getInitializer(), ctx));
    }

    @NonNull
    public J visitAssignment(@NonNull J.Assignment assignment, @NonNull ExecutionContext ctx) {
        if (assignment == null) {
            throw new NullPointerException("assignment is marked non-null but is null");
        }
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        J.Assignment a = (J.Assignment)super.visitAssignment(assignment, (Object)ctx);
        if (!a.getType().isAssignableFrom(TimeClassNames.JODA_CLASS_PATTERN)) {
            return a;
        }
        if (!(a.getVariable() instanceof J.Identifier)) {
            return assignment;
        }
        J.Identifier varName = (J.Identifier)a.getVariable();
        Optional<J.VariableDeclarations.NamedVariable> mayBeVar = this.findVarInScope(varName.getSimpleName());
        if (!mayBeVar.isPresent() || this.unsafeVars.contains(mayBeVar.get())) {
            return assignment;
        }
        return VarTemplates.getTemplate(a).apply(this.updateCursor((Tree)a), a.getCoordinates().replace(), new Object[]{varName, a.getAssignment()});
    }

    @NonNull
    public J visitNewClass(@NonNull J.NewClass newClass, @NonNull ExecutionContext ctx) {
        if (newClass == null) {
            throw new NullPointerException("newClass is marked non-null but is null");
        }
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        MethodCall updated = (MethodCall)super.visitNewClass(newClass, (Object)ctx);
        if (this.hasJodaType(updated.getArguments())) {
            return newClass;
        }
        MethodTemplate template = AllTemplates.getTemplate(newClass);
        if (template != null) {
            return this.applyTemplate((MethodCall)newClass, updated, template).orElse((J)newClass);
        }
        if (this.areArgumentsAssignable(updated)) {
            return updated;
        }
        return newClass;
    }

    @NonNull
    public J visitMethodInvocation(@NonNull J.MethodInvocation method, @NonNull ExecutionContext ctx) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
        if (this.hasJodaType(m.getArguments()) || this.isJodaVarRef(m.getSelect())) {
            return method;
        }
        MethodTemplate template = AllTemplates.getTemplate(method);
        if (template != null) {
            return this.applyTemplate((MethodCall)method, (MethodCall)m, template).orElse((J)method);
        }
        if (method.getMethodType().getDeclaringType().isAssignableFrom(TimeClassNames.JODA_CLASS_PATTERN)) {
            return method;
        }
        if (this.areArgumentsAssignable((MethodCall)m)) {
            return m;
        }
        return method;
    }

    @NonNull
    public J visitFieldAccess(@NonNull J.FieldAccess fieldAccess, @NonNull ExecutionContext ctx) {
        if (fieldAccess == null) {
            throw new NullPointerException("fieldAccess is marked non-null but is null");
        }
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        J.FieldAccess f = (J.FieldAccess)super.visitFieldAccess(fieldAccess, (Object)ctx);
        if (TypeUtils.isOfClassType((JavaType)f.getType(), (String)"org.joda.time.DateTimeZone") && f.getSimpleName().equals("UTC")) {
            return JavaTemplate.builder((String)"ZoneOffset.UTC").imports(new String[]{"java.time.ZoneOffset"}).build().apply(this.updateCursor((Tree)f), f.getCoordinates().replace(), new Object[0]);
        }
        return f;
    }

    @NonNull
    public J visitIdentifier(@NonNull J.Identifier ident, @NonNull ExecutionContext ctx) {
        if (ident == null) {
            throw new NullPointerException("ident is marked non-null but is null");
        }
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        if (!this.isJodaVarRef((Expression)ident)) {
            return super.visitIdentifier(ident, (Object)ctx);
        }
        Optional<J.VariableDeclarations.NamedVariable> mayBeVar = this.findVarInScope(ident.getSimpleName());
        if (!mayBeVar.isPresent() || this.unsafeVars.contains(mayBeVar.get())) {
            return ident;
        }
        JavaType.Class jodaType = (JavaType.Class)ident.getType();
        JavaType.Class fqType = TimeClassMap.getJavaTimeType(jodaType.getFullyQualifiedName());
        return ident.withType((JavaType)fqType).withFieldType(ident.getFieldType().withType((JavaType)fqType));
    }

    private boolean hasJodaType(List<Expression> exprs) {
        for (Expression expr : exprs) {
            JavaType exprType = expr.getType();
            if (exprType == null || !exprType.isAssignableFrom(TimeClassNames.JODA_CLASS_PATTERN)) continue;
            return true;
        }
        return false;
    }

    private Optional<J> applyTemplate(MethodCall original, MethodCall updated, MethodTemplate template) {
        if (template.getMatcher().matches(original)) {
            Expression[] args = template.getTemplateArgsFunc().apply(updated);
            if (args.length == 0) {
                return Optional.of(template.getTemplate().apply(this.updateCursor((Tree)updated), updated.getCoordinates().replace(), new Object[0]));
            }
            return Optional.of(template.getTemplate().apply(this.updateCursor((Tree)updated), updated.getCoordinates().replace(), (Object[])args));
        }
        return Optional.empty();
    }

    private boolean areArgumentsAssignable(MethodCall m) {
        if (m.getMethodType() == null || this.getArgumentsCount(m) != m.getMethodType().getParameterTypes().size()) {
            return false;
        }
        if (this.getArgumentsCount(m) == 0) {
            return true;
        }
        for (int i = 0; i < m.getArguments().size(); ++i) {
            if (TypeUtils.isAssignableTo((JavaType)((JavaType)m.getMethodType().getParameterTypes().get(i)), (JavaType)((Expression)m.getArguments().get(i)).getType())) continue;
            return false;
        }
        return true;
    }

    private int getArgumentsCount(MethodCall m) {
        if (m.getArguments().size() == 1 && m.getArguments().get(0) instanceof J.Empty) {
            return 0;
        }
        return m.getArguments().size();
    }

    private boolean isJodaVarRef(@Nullable Expression expr) {
        if (expr == null || expr.getType() == null || !expr.getType().isAssignableFrom(TimeClassNames.JODA_CLASS_PATTERN)) {
            return false;
        }
        if (expr instanceof J.FieldAccess) {
            return ((J.FieldAccess)expr).getName().getFieldType() != null;
        }
        if (expr instanceof J.Identifier) {
            return ((J.Identifier)expr).getFieldType() != null;
        }
        return false;
    }
}

