/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.joda;

import lombok.NonNull;
import org.openrewrite.analysis.dataflow.DataFlowNode;
import org.openrewrite.analysis.dataflow.DataFlowSpec;
import org.openrewrite.java.migrate.joda.templates.TimeClassNames;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

public class JodaTimeFlowSpec
extends DataFlowSpec {
    public boolean isSource(@NonNull DataFlowNode srcNode) {
        if (srcNode == null) {
            throw new NullPointerException("srcNode is marked non-null but is null");
        }
        Object value = srcNode.getCursor().getParentTreeCursor().getValue();
        if (value instanceof J.Assignment && ((J.Assignment)value).getVariable() instanceof J.Identifier) {
            return JodaTimeFlowSpec.isJodaType(((J.Assignment)value).getVariable().getType());
        }
        if (value instanceof J.VariableDeclarations.NamedVariable) {
            return JodaTimeFlowSpec.isJodaType(((J.VariableDeclarations.NamedVariable)value).getType());
        }
        return false;
    }

    public boolean isSink(@NonNull DataFlowNode sinkNode) {
        if (sinkNode == null) {
            throw new NullPointerException("sinkNode is marked non-null but is null");
        }
        Object value = sinkNode.getCursor().getValue();
        Object parent = sinkNode.getCursor().getParentTreeCursor().getValue();
        if (parent instanceof J.MethodInvocation) {
            J.MethodInvocation method = (J.MethodInvocation)parent;
            return method.getSelect() != null && method.getSelect().equals(value) || method.getArguments().stream().anyMatch(a -> a.equals(value));
        }
        return parent instanceof J.VariableDeclarations.NamedVariable || parent instanceof J.NewClass || parent instanceof J.Assignment || parent instanceof J.Return;
    }

    static boolean isJodaType(JavaType type) {
        if (!(type instanceof JavaType.Class)) {
            return false;
        }
        return type.isAssignableFrom(TimeClassNames.JODA_CLASS_PATTERN);
    }
}

