/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.util;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public class StreamFindFirst
extends Recipe {
    private static final MethodMatcher COLLECTION_STREAM_MATCHER = new MethodMatcher("java.util.Collection stream()", true);
    private static final MethodMatcher STREAM_FIND_FIRST_MATCHER = new MethodMatcher("java.util.stream.Stream findFirst()", true);
    private static final MethodMatcher OPTIONAL_OR_ELSE_THROW_MATCHER = new MethodMatcher("java.util.Optional orElseThrow()", true);

    public String getDisplayName() {
        return "Use `getFirst()` instead of `stream().findFirst().orElseThrow()`";
    }

    public String getDescription() {
        return "For SequencedCollections, use `collection.getFirst()` instead of `collection.stream().findFirst().orElseThrow()`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        JavaIsoVisitor<ExecutionContext> javaIsoVisitor = new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
                if (!OPTIONAL_OR_ELSE_THROW_MATCHER.matches((MethodCall)mi) || !(mi.getSelect() instanceof J.MethodInvocation)) {
                    return mi;
                }
                J.MethodInvocation optional = (J.MethodInvocation)mi.getSelect();
                if (!STREAM_FIND_FIRST_MATCHER.matches((MethodCall)optional) || !(optional.getSelect() instanceof J.MethodInvocation)) {
                    return mi;
                }
                J.MethodInvocation stream = (J.MethodInvocation)optional.getSelect();
                if (!COLLECTION_STREAM_MATCHER.matches((MethodCall)stream) || !TypeUtils.isOfClassType((JavaType)stream.getSelect().getType(), (String)"java.util.SequencedCollection")) {
                    return mi;
                }
                JavaType.Method methodType = stream.getMethodType().withName("getFirst");
                return stream.withName(stream.getName().withSimpleName("getFirst").withType((JavaType)methodType)).withMethodType(methodType).withPrefix(mi.getPrefix());
            }
        };
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(21), new UsesMethod(COLLECTION_STREAM_MATCHER), new UsesMethod(STREAM_FIND_FIRST_MATCHER), new UsesMethod(OPTIONAL_OR_ELSE_THROW_MATCHER)}), (TreeVisitor)javaIsoVisitor);
    }
}

