/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.joda.templates;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.migrate.joda.templates.AbstractDateTimeTemplates;
import org.openrewrite.java.migrate.joda.templates.AbstractDurationTemplates;
import org.openrewrite.java.migrate.joda.templates.AbstractInstantTemplates;
import org.openrewrite.java.migrate.joda.templates.AbstractIntervalTemplates;
import org.openrewrite.java.migrate.joda.templates.BaseDateTime;
import org.openrewrite.java.migrate.joda.templates.BaseDurationTemplates;
import org.openrewrite.java.migrate.joda.templates.BaseIntervalTemplates;
import org.openrewrite.java.migrate.joda.templates.DateTimeFormatTemplates;
import org.openrewrite.java.migrate.joda.templates.DateTimeFormatterTemplates;
import org.openrewrite.java.migrate.joda.templates.DateTimeTemplates;
import org.openrewrite.java.migrate.joda.templates.DurationTemplates;
import org.openrewrite.java.migrate.joda.templates.InstantTemplates;
import org.openrewrite.java.migrate.joda.templates.IntervalTemplates;
import org.openrewrite.java.migrate.joda.templates.MethodTemplate;
import org.openrewrite.java.migrate.joda.templates.Templates;
import org.openrewrite.java.migrate.joda.templates.TimeZoneTemplates;
import org.openrewrite.java.tree.MethodCall;

public class AllTemplates {
    private static final MethodMatcher ANY_BASE_DATETIME = new MethodMatcher("org.joda.time.base.BaseDateTime *(..)");
    private static final MethodMatcher ANY_NEW_DATE_TIME = new MethodMatcher("org.joda.time.DateTime<constructor>(..)");
    private static final MethodMatcher ANY_DATE_TIME = new MethodMatcher("org.joda.time.DateTime *(..)");
    private static final MethodMatcher ANY_DATE_TIMEZONE = new MethodMatcher("org.joda.time.DateTimeZone *(..)");
    private static final MethodMatcher ANY_TIME_FORMAT = new MethodMatcher("org.joda.time.format.DateTimeFormat *(..)");
    private static final MethodMatcher ANY_TIME_FORMATTER = new MethodMatcher("org.joda.time.format.DateTimeFormatter *(..)");
    private static final MethodMatcher ANY_NEW_DURATION = new MethodMatcher("org.joda.time.Duration<constructor>(..)");
    private static final MethodMatcher ANY_DURATION = new MethodMatcher("org.joda.time.Duration *(..)");
    private static final MethodMatcher ANY_BASE_DURATION = new MethodMatcher("org.joda.time.base.BaseDuration *(..)");
    private static final MethodMatcher ANY_ABSTRACT_INSTANT = new MethodMatcher("org.joda.time.base.AbstractInstant *(..)");
    private static final MethodMatcher ANY_ABSTRACT_DATE_TIME = new MethodMatcher("org.joda.time.base.AbstractDateTime *(..)");
    private static final MethodMatcher ANY_ABSTRACT_DURATION = new MethodMatcher("org.joda.time.base.AbstractDuration *(..)");
    private static final MethodMatcher ANY_INSTANT = new MethodMatcher("org.joda.time.Instant *(..)");
    private static final MethodMatcher ANY_NEW_INSTANT = new MethodMatcher("org.joda.time.Instant<constructor>(..)");
    private static final MethodMatcher ANY_NEW_INTERVAL = new MethodMatcher("org.joda.time.Interval<constructor>(..)");
    private static final MethodMatcher ANY_ABSTRACT_INTERVAL = new MethodMatcher("org.joda.time.base.AbstractInterval *(..)");
    private static final MethodMatcher ANY_BASE_INTERVAL = new MethodMatcher("org.joda.time.base.BaseInterval *(..)");
    private static List<MatcherAndTemplates> templates = new ArrayList<MatcherAndTemplates>(){
        {
            this.add(new MatcherAndTemplates(ANY_ABSTRACT_DATE_TIME, new AbstractDateTimeTemplates()));
            this.add(new MatcherAndTemplates(ANY_ABSTRACT_DURATION, new AbstractDurationTemplates()));
            this.add(new MatcherAndTemplates(ANY_ABSTRACT_INSTANT, new AbstractInstantTemplates()));
            this.add(new MatcherAndTemplates(ANY_BASE_DATETIME, new BaseDateTime()));
            this.add(new MatcherAndTemplates(ANY_TIME_FORMAT, new DateTimeFormatTemplates()));
            this.add(new MatcherAndTemplates(ANY_TIME_FORMATTER, new DateTimeFormatterTemplates()));
            this.add(new MatcherAndTemplates(ANY_NEW_DATE_TIME, new DateTimeTemplates()));
            this.add(new MatcherAndTemplates(ANY_DATE_TIME, new DateTimeTemplates()));
            this.add(new MatcherAndTemplates(ANY_NEW_DURATION, new DurationTemplates()));
            this.add(new MatcherAndTemplates(ANY_DURATION, new DurationTemplates()));
            this.add(new MatcherAndTemplates(ANY_BASE_DURATION, new BaseDurationTemplates()));
            this.add(new MatcherAndTemplates(ANY_DATE_TIMEZONE, new TimeZoneTemplates()));
            this.add(new MatcherAndTemplates(ANY_INSTANT, new InstantTemplates()));
            this.add(new MatcherAndTemplates(ANY_NEW_INSTANT, new InstantTemplates()));
            this.add(new MatcherAndTemplates(ANY_NEW_INTERVAL, new IntervalTemplates()));
            this.add(new MatcherAndTemplates(ANY_ABSTRACT_INTERVAL, new AbstractIntervalTemplates()));
            this.add(new MatcherAndTemplates(ANY_BASE_INTERVAL, new BaseIntervalTemplates()));
        }
    };

    public static MethodTemplate getTemplate(MethodCall method) {
        return AllTemplates.getTemplateGroup(method).flatMap(templates -> templates.getTemplates().stream().filter(template -> template.getMatcher().matches(method) && templates.matchesMethodCall(method, (MethodTemplate)template)).findFirst()).orElse(null);
    }

    private static Optional<Templates> getTemplateGroup(MethodCall method) {
        for (MatcherAndTemplates matcherAndTemplates : templates) {
            if (!matcherAndTemplates.getMatcher().matches(method)) continue;
            return Optional.of(matcherAndTemplates.getTemplates());
        }
        return Optional.empty();
    }

    private static final class MatcherAndTemplates {
        private final MethodMatcher matcher;
        private final Templates templates;

        @ConstructorProperties(value={"matcher", "templates"})
        @Generated
        public MatcherAndTemplates(MethodMatcher matcher, Templates templates) {
            this.matcher = matcher;
            this.templates = templates;
        }

        @Generated
        public MethodMatcher getMatcher() {
            return this.matcher;
        }

        @Generated
        public Templates getTemplates() {
            return this.templates;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MatcherAndTemplates)) {
                return false;
            }
            MatcherAndTemplates other = (MatcherAndTemplates)o;
            MethodMatcher this$matcher = this.getMatcher();
            MethodMatcher other$matcher = other.getMatcher();
            if (this$matcher == null ? other$matcher != null : !this$matcher.equals(other$matcher)) {
                return false;
            }
            Templates this$templates = this.getTemplates();
            Templates other$templates = other.getTemplates();
            return !(this$templates == null ? other$templates != null : !this$templates.equals(other$templates));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            MethodMatcher $matcher = this.getMatcher();
            result = result * 59 + ($matcher == null ? 43 : $matcher.hashCode());
            Templates $templates = this.getTemplates();
            result = result * 59 + ($templates == null ? 43 : $templates.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "AllTemplates.MatcherAndTemplates(matcher=" + this.getMatcher() + ", templates=" + this.getTemplates() + ")";
        }
    }
}

