/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.openapi.swagger;

import java.util.ArrayList;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public class MigrateApiImplicitParamDataTypeClass
extends Recipe {
    private static final String FQN_SCHEMA = "io.swagger.v3.oas.annotations.media.Schema";

    public String getDisplayName() {
        return "Migrate `@ApiImplicitParam(dataTypeClass=Foo.class)` to `@Parameter(schema=@Schema(implementation=Foo.class))`";
    }

    public String getDescription() {
        return "Migrate `@ApiImplicitParam(dataTypeClass=Foo.class)` to `@Parameter(schema=@Schema(implementation=Foo.class))`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod("io.swagger.annotations.ApiImplicitParam dataTypeClass()", false), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext ctx) {
                J.Annotation anno = super.visitAnnotation(annotation, (Object)ctx);
                if (!new AnnotationMatcher("io.swagger.v3.oas.annotations.Parameter").matches(anno)) {
                    return anno;
                }
                StringBuilder tpl = new StringBuilder();
                ArrayList<Object> args = new ArrayList<Object>();
                for (Expression exp : anno.getArguments()) {
                    if (!args.isEmpty()) {
                        tpl.append(", ");
                    }
                    if (this.isDataTypeClass(exp)) {
                        J.FieldAccess fieldAccess = (J.FieldAccess)((J.Assignment)exp).getAssignment();
                        tpl.append("schema = @Schema(implementation = #{any()})");
                        args.add(fieldAccess);
                        continue;
                    }
                    tpl.append("#{any()}");
                    args.add(exp);
                }
                anno = (J.Annotation)JavaTemplate.builder((String)tpl.toString()).imports(new String[]{MigrateApiImplicitParamDataTypeClass.FQN_SCHEMA}).javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"swagger-annotations"})).build().apply(this.updateCursor((Tree)anno), annotation.getCoordinates().replaceArguments(), args.toArray());
                this.maybeAddImport(MigrateApiImplicitParamDataTypeClass.FQN_SCHEMA, false);
                return (J.Annotation)this.maybeAutoFormat((J)annotation, (J)anno, ctx, this.getCursor().getParentTreeCursor());
            }

            private boolean isDataTypeClass(Expression exp) {
                return exp instanceof J.Assignment && ((J.Identifier)((J.Assignment)exp).getVariable()).getSimpleName().equals("dataTypeClass");
            }
        });
    }
}

