/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.openapi.swagger;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public class ConvertApiResponseToContent
extends Recipe {
    private static final AnnotationMatcher ANNOTATION_MATCHER = new AnnotationMatcher("@io.swagger.v3.oas.annotations.responses.ApiResponse");
    private static final String FQN_CONTENT = "io.swagger.v3.oas.annotations.media.Content";
    private static final String FQN_SCHEMA = "io.swagger.v3.oas.annotations.media.Schema";
    private static final String FQN_ARRAYSCHEMA = "io.swagger.v3.oas.annotations.media.ArraySchema";

    public String getDisplayName() {
        return "Convert API response to content annotation";
    }

    public String getDescription() {
        return "Convert API response to content annotation";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("io.swagger.v3.oas.annotations.responses.ApiResponse", Boolean.valueOf(true)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            public J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext ctx) {
                String type;
                J.Annotation an = super.visitAnnotation(annotation, (Object)ctx);
                if (!ANNOTATION_MATCHER.matches(an) || an.getArguments() == null) {
                    return an;
                }
                AtomicReference contentClass = new AtomicReference();
                AtomicReference<@Nullable V> containerType = new AtomicReference();
                List maybeArgsWithoutResponse = ListUtils.map((List)an.getArguments(), arg -> {
                    if (!(arg instanceof J.Assignment)) {
                        return arg;
                    }
                    J.Assignment assign = (J.Assignment)arg;
                    if (!(assign.getVariable() instanceof J.Identifier)) {
                        return arg;
                    }
                    String name = ((J.Identifier)assign.getVariable()).getSimpleName();
                    @Nullable Expression assignment = assign.getAssignment();
                    if ("response".equals(name) && assignment instanceof J.FieldAccess) {
                        contentClass.set((J.FieldAccess)assignment);
                        return null;
                    }
                    if ("responseContainer".equals(name) && assignment instanceof J.Literal) {
                        containerType.set((J.Literal)assignment);
                        return null;
                    }
                    return arg;
                });
                if (maybeArgsWithoutResponse.size() >= an.getArguments().size()) {
                    return an;
                }
                String string = type = containerType.get() != null ? ((J.Literal)containerType.get()).toString() : null;
                String inner = "List".equals(type) || "Set".equals(type) ? String.format("array = @ArraySchema(uniqueItems = %b, schema = @Schema(implementation = #{any()})))", "Set".equals(type)) : ("Map".equals(type) ? "schema = @Schema(type = \"object\", additionalPropertiesSchema = #{any()}))" : "schema = @Schema(implementation = #{any()}))");
                String arguments = StringUtils.repeat((String)"#{any()}, ", (int)maybeArgsWithoutResponse.size());
                an = (J.Annotation)JavaTemplate.builder((String)(arguments + "content = @Content(mediaType = \"application/json\", " + inner)).imports(new String[]{"io.swagger.v3.oas.annotations.media.*"}).javaParser(JavaParser.fromJavaVersion().classpath(new String[]{"swagger-annotations"})).build().apply(this.getCursor(), an.getCoordinates().replaceArguments(), ListUtils.concat((List)maybeArgsWithoutResponse, (Object)((Expression)contentClass.get())).toArray());
                this.maybeAddImport(ConvertApiResponseToContent.FQN_CONTENT);
                this.maybeAddImport(ConvertApiResponseToContent.FQN_SCHEMA);
                this.maybeAddImport(ConvertApiResponseToContent.FQN_ARRAYSCHEMA);
                return (J.Annotation)this.maybeAutoFormat((J)annotation, (J)an, ctx, this.getCursor().getParentTreeCursor());
            }
        });
    }
}

