/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.quarkus;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;

public class ConfigPropertiesToConfigMapping
extends Recipe {
    public String getDisplayName() {
        return "Use `@ConfigMapping`";
    }

    public String getDescription() {
        return "Migrate Quarkus configuration classes annotated with `@ConfigProperties` to the equivalent Smallrye `@ConfigMapping`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("io.quarkus.arc.config.ConfigProperties", null), (TreeVisitor)new ConfigPropertiesToConfigMappingVisitor());
    }

    private static class ConfigPropertiesToConfigMappingVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private static final AnnotationMatcher CONFIG_PROPERTIES_ANNOTATION_MATCHER = new AnnotationMatcher("@io.quarkus.arc.config.ConfigProperties");

        private ConfigPropertiesToConfigMappingVisitor() {
        }

        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
            J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
            if (cd.getLeadingAnnotations().stream().anyMatch(arg_0 -> ((AnnotationMatcher)CONFIG_PROPERTIES_ANNOTATION_MATCHER).matches(arg_0)) && cd.getKind() == J.ClassDeclaration.Kind.Type.Interface) {
                this.doAfterVisit(new ChangeType("io.quarkus.arc.config.ConfigProperties", "io.smallrye.config.ConfigMapping", Boolean.valueOf(true)).getVisitor());
            }
            return cd;
        }
    }
}

