/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.quarkus;

import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.RemoveAnnotationVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public class Slf4jToQuarkusLogger
extends Recipe {
    private static final String ORG_SLF_4_J_LOGGER = "org.slf4j.Logger";
    private static final MethodMatcher LOGGER_TRACE = new MethodMatcher("org.slf4j.Logger trace(String, ..)");
    private static final MethodMatcher LOGGER_DEBUG = new MethodMatcher("org.slf4j.Logger debug(String, ..)");
    private static final MethodMatcher LOGGER_INFO = new MethodMatcher("org.slf4j.Logger info(String, ..)");
    private static final MethodMatcher LOGGER_WARN = new MethodMatcher("org.slf4j.Logger warn(String, ..)");
    private static final MethodMatcher LOGGER_ERROR = new MethodMatcher("org.slf4j.Logger error(String, ..)");

    public String getDisplayName() {
        return "Migrate SLF4J Logger injection and usage to Quarkus static `Log`";
    }

    public String getDescription() {
        return "Removes usage of SLF4J Logger fields, adjusts imports, and replaces logger method calls with static Quarkus Log calls, including message formatting and method renaming for parameterized logging.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType(ORG_SLF_4_J_LOGGER, Boolean.valueOf(true)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
                if (cd != classDecl) {
                    this.doAfterVisit((TreeVisitor)new RemoveAnnotationVisitor(new AnnotationMatcher("@lombok.extern.slf4j.Slf4j")));
                }
                return cd;
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation methodInvocation, ExecutionContext ctx) {
                J.MethodInvocation mi = super.visitMethodInvocation(methodInvocation, (Object)ctx);
                if (!(LOGGER_TRACE.matches((MethodCall)mi) || LOGGER_DEBUG.matches((MethodCall)mi) || LOGGER_INFO.matches((MethodCall)mi) || LOGGER_WARN.matches((MethodCall)mi) || LOGGER_ERROR.matches((MethodCall)mi))) {
                    return mi;
                }
                this.maybeRemoveImport(Slf4jToQuarkusLogger.ORG_SLF_4_J_LOGGER);
                this.maybeAddImport("io.quarkus.logging.Log");
                List args = ListUtils.mapFirst((List)mi.getArguments(), arg -> arg instanceof J.Literal && ((J.Literal)arg).getValue() instanceof String ? ((J.Literal)arg).withValue((Object)((String)((J.Literal)arg).getValue()).replace("{}", "%s")).withValueSource(((J.Literal)arg).getValueSource().replace("{}", "%s")) : arg);
                String placeholders = String.join((CharSequence)", ", Collections.nCopies(args.size(), "#{any()}"));
                String template = String.format("Log.%s%s(%s)", mi.getSimpleName(), 1 < args.size() ? "f" : "", placeholders);
                return (J.MethodInvocation)JavaTemplate.builder((String)template).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"quarkus-core"})).imports(new String[]{"io.quarkus.logging.Log"}).build().apply(this.updateCursor((Tree)mi), mi.getCoordinates().replace(), args.toArray());
            }

            public // Could not load outer class - annotation placement on inner may be incorrect
             @Nullable J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
                J.VariableDeclarations variableDeclarations = super.visitVariableDeclarations(multiVariable, (Object)ctx);
                if (TypeUtils.isOfClassType((JavaType)variableDeclarations.getType(), (String)Slf4jToQuarkusLogger.ORG_SLF_4_J_LOGGER)) {
                    this.maybeRemoveImport(Slf4jToQuarkusLogger.ORG_SLF_4_J_LOGGER);
                    this.maybeRemoveImport("org.slf4j.LoggerFactory");
                    this.maybeRemoveImport("javax.inject.Inject");
                    this.maybeRemoveImport("jakarta.inject.Inject");
                    return null;
                }
                return variableDeclarations;
            }
        });
    }
}

