/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.quarkus;

import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.quarkus.ChangeQuarkusPropertyKeyVisitor;
import org.openrewrite.quarkus.search.FindQuarkusProperties;

public final class ChangeQuarkusPropertyKey
extends Recipe {
    @Option(displayName="Old property key", description="The property key to rename. Supports regex.", example="quarkus.hibernate-search-orm.automatic-indexing.synchronization.strategy")
    private final String oldPropertyKey;
    @Option(displayName="New property key", description="The new name for the property key. Supports regex.", example="quarkus.hibernate-search-orm.indexing.plan.synchronization.strategy")
    private final String newPropertyKey;
    @Option(displayName="Profile", description="The profile where the property is defined. If not specified, the property will be changed on all profiles by default.", required=false, example="dev")
    @Nullable
    private final String profile;
    @Option(displayName="Change for all profiles", description="If set to true, the property will be changed on all available profiles. Defaults to `true` if a profile is not defined.", required=false, example="false")
    @Nullable
    private final Boolean changeAllProfiles;
    @Option(displayName="Optional list of file path matcher", description="Each value in this list represents a glob expression that is used to match which files will be modified. If this value is not present, this recipe will query the execution context for reasonable defaults. (\"**/application.yml\", \"**/application.yaml\", \"**/application.properties\" and \"**/META-INF/microprofile-config.properties\".", required=false, example="[\"**/application.yaml\"]")
    @Nullable
    private final List<String> pathExpressions;

    public Validated<Object> validate() {
        Validated validated = super.validate().and(Validated.notBlank((String)"newPropertyKey", (String)this.oldPropertyKey)).and(Validated.notBlank((String)"newPropertyKey", (String)this.newPropertyKey));
        if (StringUtils.isNotEmpty((String)this.profile)) {
            validated = validated.and(Validated.test((String)"changeAllProfiles", (String)"cannot be used together with profile", (Object)this.changeAllProfiles, x -> x == null || x == false));
        }
        return validated;
    }

    public String getDisplayName() {
        return "Change Quarkus configuration property key";
    }

    public String getDescription() {
        return "Change the key of a property in Quarkus configuration files.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new FindQuarkusProperties(this.oldPropertyKey, this.profile, this.changeAllProfiles).getVisitor(), (TreeVisitor)new ChangeQuarkusPropertyKeyVisitor(this.oldPropertyKey, this.newPropertyKey, this.profile, this.changeAllProfiles, this.pathExpressions));
    }

    @ConstructorProperties(value={"oldPropertyKey", "newPropertyKey", "profile", "changeAllProfiles", "pathExpressions"})
    @Generated
    public ChangeQuarkusPropertyKey(String oldPropertyKey, String newPropertyKey, @Nullable String profile, @Nullable Boolean changeAllProfiles, @Nullable List<String> pathExpressions) {
        this.oldPropertyKey = oldPropertyKey;
        this.newPropertyKey = newPropertyKey;
        this.profile = profile;
        this.changeAllProfiles = changeAllProfiles;
        this.pathExpressions = pathExpressions;
    }

    @Generated
    public String getOldPropertyKey() {
        return this.oldPropertyKey;
    }

    @Generated
    public String getNewPropertyKey() {
        return this.newPropertyKey;
    }

    @Nullable
    @Generated
    public String getProfile() {
        return this.profile;
    }

    @Nullable
    @Generated
    public Boolean getChangeAllProfiles() {
        return this.changeAllProfiles;
    }

    @Nullable
    @Generated
    public List<String> getPathExpressions() {
        return this.pathExpressions;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ChangeQuarkusPropertyKey(oldPropertyKey=" + this.getOldPropertyKey() + ", newPropertyKey=" + this.getNewPropertyKey() + ", profile=" + this.getProfile() + ", changeAllProfiles=" + this.getChangeAllProfiles() + ", pathExpressions=" + this.getPathExpressions() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeQuarkusPropertyKey)) {
            return false;
        }
        ChangeQuarkusPropertyKey other = (ChangeQuarkusPropertyKey)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$changeAllProfiles = this.getChangeAllProfiles();
        Boolean other$changeAllProfiles = other.getChangeAllProfiles();
        if (this$changeAllProfiles == null ? other$changeAllProfiles != null : !((Object)this$changeAllProfiles).equals(other$changeAllProfiles)) {
            return false;
        }
        String this$oldPropertyKey = this.getOldPropertyKey();
        String other$oldPropertyKey = other.getOldPropertyKey();
        if (this$oldPropertyKey == null ? other$oldPropertyKey != null : !this$oldPropertyKey.equals(other$oldPropertyKey)) {
            return false;
        }
        String this$newPropertyKey = this.getNewPropertyKey();
        String other$newPropertyKey = other.getNewPropertyKey();
        if (this$newPropertyKey == null ? other$newPropertyKey != null : !this$newPropertyKey.equals(other$newPropertyKey)) {
            return false;
        }
        String this$profile = this.getProfile();
        String other$profile = other.getProfile();
        if (this$profile == null ? other$profile != null : !this$profile.equals(other$profile)) {
            return false;
        }
        List<String> this$pathExpressions = this.getPathExpressions();
        List<String> other$pathExpressions = other.getPathExpressions();
        return !(this$pathExpressions == null ? other$pathExpressions != null : !((Object)this$pathExpressions).equals(other$pathExpressions));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeQuarkusPropertyKey;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $changeAllProfiles = this.getChangeAllProfiles();
        result = result * 59 + ($changeAllProfiles == null ? 43 : ((Object)$changeAllProfiles).hashCode());
        String $oldPropertyKey = this.getOldPropertyKey();
        result = result * 59 + ($oldPropertyKey == null ? 43 : $oldPropertyKey.hashCode());
        String $newPropertyKey = this.getNewPropertyKey();
        result = result * 59 + ($newPropertyKey == null ? 43 : $newPropertyKey.hashCode());
        String $profile = this.getProfile();
        result = result * 59 + ($profile == null ? 43 : $profile.hashCode());
        List<String> $pathExpressions = this.getPathExpressions();
        result = result * 59 + ($pathExpressions == null ? 43 : ((Object)$pathExpressions).hashCode());
        return result;
    }
}

