/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.quarkus.quarkus2;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.RemovePlugin;
import org.openrewrite.maven.search.FindPlugin;
import org.openrewrite.xml.tree.Xml;

public class RemoveAvroMavenPlugin
extends Recipe {
    public String getDisplayName() {
        return "Remove `avro-maven-plugin`";
    }

    public String getDescription() {
        return "Removes the `avro-maven-plugin` if the `quarkus-maven-plugin` is found in the project's `pom.xml`. Avro has been integrated with the Quarkus code generation mechanism. This replaces the need to use the Avro plugin.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new MavenIsoVisitor<ExecutionContext>(){

            public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
                if (!FindPlugin.find((Xml.Document)document, (String)"io.quarkus", (String)"quarkus-maven-plugin").isEmpty()) {
                    document = (Xml.Document)SearchResult.found((Tree)document);
                }
                return super.visitDocument(document, (Object)ctx);
            }
        }, (TreeVisitor)new MavenIsoVisitor<ExecutionContext>(){

            public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
                this.doAfterVisit(new RemovePlugin("org.apache.avro", "avro-maven-plugin").getVisitor());
                return document;
            }
        });
    }
}

