/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.quarkus;

import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.openrewrite.ExecutionContext;
import org.openrewrite.TreeVisitor;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.search.FindPlugin;
import org.openrewrite.xml.AddToTagVisitor;
import org.openrewrite.xml.tree.Xml;

public class AddQuarkusMavenPluginGoalVisitor
extends MavenIsoVisitor<ExecutionContext> {
    private static final Predicate<? super Xml.Tag> TAG_KEY_NAME_MATCHES = tag -> "goal".equals(tag.getName());
    private static final Predicate<? super Xml.Tag> TAG_HAS_CONTENT = tag -> tag.getContent() != null && tag.getContent().size() == 1;
    private static final Predicate<? super Xml.Tag> TAG_CONTENT_IS_CHAR_DATA = tag -> tag.getContent().get(0) instanceof Xml.CharData;
    private static final BiPredicate<? super Xml.Tag, String> TAG_CONTENT_MATCHES = (tag, str) -> ((Xml.CharData)tag.getContent().get(0)).getText().equals(str);
    private final String goalName;

    public AddQuarkusMavenPluginGoalVisitor(String goalName) {
        this.goalName = goalName;
    }

    public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
        FindPlugin.find((Xml.Document)document, (String)"io.quarkus", (String)"quarkus-maven-plugin").forEach(plugin -> {
            Optional maybeExecutions = plugin.getChild("executions");
            if (!maybeExecutions.isPresent()) {
                Xml.Tag executionsTag = Xml.Tag.build((String)"<executions/>");
                this.doAfterVisit((TreeVisitor)new AddToTagVisitor(plugin, executionsTag));
                this.doAfterVisit((TreeVisitor)new AddQuarkusMavenPluginGoalVisitor(this.goalName));
            } else {
                Xml.Tag executions = (Xml.Tag)maybeExecutions.get();
                Optional<Xml.Tag> maybeExecution = executions.getChildren().stream().filter(exe -> "execution".equals(exe.getName())).findFirst();
                if (!maybeExecution.isPresent()) {
                    Xml.Tag executionTag = Xml.Tag.build((String)"<execution/>");
                    this.doAfterVisit((TreeVisitor)new AddToTagVisitor(executions, executionTag));
                    this.doAfterVisit((TreeVisitor)new AddQuarkusMavenPluginGoalVisitor(this.goalName));
                } else {
                    Xml.Tag execution = maybeExecution.get();
                    Optional maybeGoals = execution.getChild("goals");
                    if (!maybeGoals.isPresent()) {
                        Xml.Tag goalsTag = Xml.Tag.build((String)"<goals/>");
                        this.doAfterVisit((TreeVisitor)new AddToTagVisitor(execution, goalsTag));
                        this.doAfterVisit((TreeVisitor)new AddQuarkusMavenPluginGoalVisitor(this.goalName));
                    } else {
                        Xml.Tag goals = (Xml.Tag)maybeGoals.get();
                        Optional<Xml.Tag> foundGoals = goals.getChildren().stream().filter(TAG_KEY_NAME_MATCHES).filter(TAG_HAS_CONTENT).filter(TAG_CONTENT_IS_CHAR_DATA).filter(t -> TAG_CONTENT_MATCHES.test((Xml.Tag)t, this.goalName)).findAny();
                        if (!foundGoals.isPresent()) {
                            Xml.Tag goalsTag = Xml.Tag.build((String)("<goal>" + this.goalName + "</goal>"));
                            this.doAfterVisit((TreeVisitor)new AddToTagVisitor(goals, goalsTag));
                        }
                    }
                }
            }
        });
        return super.visitDocument(document, (Object)ctx);
    }
}

