/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.sql.search;

import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.util.deparser.ExpressionDeParser;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.sql.table.DatabaseFunctions;
import org.openrewrite.sql.table.DatabaseQueries;
import org.openrewrite.sql.trait.SqlQuery;
import org.openrewrite.sql.trait.Traits;

public final class FindFunction
extends Recipe {
    private final transient DatabaseQueries databaseQueries = new DatabaseQueries(this);
    private final transient DatabaseFunctions databaseFunctions = new DatabaseFunctions(this);
    @Option(displayName="Function name", description="The name of the function to find, case insensitive.", example="nvl")
    private final String functionName;

    public String getDisplayName() {
        return "Find SQL function";
    }

    public String getDescription() {
        return "Find SQL functions by name.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Traits.sql().asVisitor((sql, ctx) -> {
            AtomicReference<Boolean> found = new AtomicReference<Boolean>(false);
            sql.visitSql(new ExpressionDeParser((ExecutionContext)ctx, (SqlQuery)sql, found){
                final /* synthetic */ ExecutionContext val$ctx;
                final /* synthetic */ SqlQuery val$sql;
                final /* synthetic */ AtomicReference val$found;
                {
                    this.val$ctx = executionContext;
                    this.val$sql = sqlQuery;
                    this.val$found = atomicReference;
                }

                public void visit(Function function) {
                    if (StringUtils.matchesGlob((String)function.getName(), (String)FindFunction.this.functionName)) {
                        FindFunction.this.databaseQueries.insertRow(this.val$ctx, new DatabaseQueries.Row(((SourceFile)this.val$sql.getCursor().firstEnclosingOrThrow(SourceFile.class)).getSourcePath().toString(), this.val$sql.getString()));
                        FindFunction.this.databaseFunctions.insertRow(this.val$ctx, new DatabaseFunctions.Row(((SourceFile)this.val$sql.getCursor().firstEnclosingOrThrow(SourceFile.class)).getSourcePath().toString(), function.getName().toLowerCase(), this.val$sql.getString()));
                        this.val$found.set(true);
                    }
                    super.visit(function);
                }
            });
            return found.get() != false ? SearchResult.found((Tree)sql.getTree()) : sql.getTree();
        });
    }

    @Generated
    public FindFunction(String functionName) {
        this.functionName = functionName;
    }

    @Generated
    public DatabaseQueries getDatabaseQueries() {
        return this.databaseQueries;
    }

    @Generated
    public DatabaseFunctions getDatabaseFunctions() {
        return this.databaseFunctions;
    }

    @Generated
    public String getFunctionName() {
        return this.functionName;
    }

    @Generated
    public String toString() {
        return "FindFunction(databaseQueries=" + (Object)((Object)this.getDatabaseQueries()) + ", databaseFunctions=" + (Object)((Object)this.getDatabaseFunctions()) + ", functionName=" + this.getFunctionName() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindFunction)) {
            return false;
        }
        FindFunction other = (FindFunction)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$functionName = this.getFunctionName();
        String other$functionName = other.getFunctionName();
        return !(this$functionName == null ? other$functionName != null : !this$functionName.equals(other$functionName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FindFunction;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $functionName = this.getFunctionName();
        result = result * 59 + ($functionName == null ? 43 : $functionName.hashCode());
        return result;
    }
}

