/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.sql;

import java.util.Locale;
import lombok.Generated;
import net.sf.jsqlparser.statement.alter.Alter;
import net.sf.jsqlparser.statement.alter.AlterExpression;
import net.sf.jsqlparser.statement.create.table.ColDataType;
import net.sf.jsqlparser.statement.create.table.ColumnDefinition;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.sql.internal.ChangeTrackingStatementDeParser;
import org.openrewrite.sql.trait.SqlQuery;

public final class ConvertDataType
extends Recipe {
    @Option(displayName="Old data type", description="The data type to find and replace, case insensitive.", example="VARCHAR2")
    private final String oldDataType;
    @Option(displayName="New data type", description="The new data type to use as replacement.", example="VARCHAR")
    private final String newDataType;

    public String getDisplayName() {
        return "Convert SQL data type";
    }

    public String getDescription() {
        return "When migrating between SQL dialects, data types often need to be converted. For example, Oracle's `VARCHAR2` can be replaced with Postgres `VARCHAR`, or `NUMBER` with `NUMERIC`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new SqlQuery.Matcher().asVisitor(sqlQuery -> sqlQuery.visitSql(new ChangeTrackingStatementDeParser(new StringBuilder()){

            public <S> StringBuilder visit(Alter alter, S context) {
                if (alter.getAlterExpressions() != null) {
                    for (AlterExpression alterExpression : alter.getAlterExpressions()) {
                        if (alterExpression.getColDataTypeList() == null) continue;
                        for (AlterExpression.ColumnDataType columnDataType : alterExpression.getColDataTypeList()) {
                            ColDataType colDataType = columnDataType.getColDataType();
                            if (colDataType == null || colDataType.getDataType() == null || !colDataType.getDataType().equalsIgnoreCase(ConvertDataType.this.oldDataType)) continue;
                            this.trackChange(() -> colDataType.setDataType(this.preserveCase(colDataType.getDataType(), ConvertDataType.this.newDataType)));
                        }
                    }
                }
                return super.visit(alter, context);
            }

            public <S> StringBuilder visit(CreateTable createTable, S context) {
                if (createTable.getColumnDefinitions() != null) {
                    for (ColumnDefinition columnDefinition : createTable.getColumnDefinitions()) {
                        ColDataType colDataType = columnDefinition.getColDataType();
                        if (colDataType == null || colDataType.getDataType() == null || !colDataType.getDataType().equalsIgnoreCase(ConvertDataType.this.oldDataType)) continue;
                        this.trackChange(() -> colDataType.setDataType(this.preserveCase(colDataType.getDataType(), ConvertDataType.this.newDataType)));
                    }
                }
                return super.visit(createTable, context);
            }

            private String preserveCase(String original, String replacement) {
                if (original.equals(original.toUpperCase(Locale.ROOT))) {
                    return replacement.toUpperCase(Locale.ROOT);
                }
                if (original.equals(original.toLowerCase(Locale.ROOT))) {
                    return replacement.toLowerCase(Locale.ROOT);
                }
                return replacement;
            }
        }));
    }

    @Generated
    public ConvertDataType(String oldDataType, String newDataType) {
        this.oldDataType = oldDataType;
        this.newDataType = newDataType;
    }

    @Generated
    public String getOldDataType() {
        return this.oldDataType;
    }

    @Generated
    public String getNewDataType() {
        return this.newDataType;
    }

    @Generated
    public String toString() {
        return "ConvertDataType(oldDataType=" + this.getOldDataType() + ", newDataType=" + this.getNewDataType() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConvertDataType)) {
            return false;
        }
        ConvertDataType other = (ConvertDataType)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$oldDataType = this.getOldDataType();
        String other$oldDataType = other.getOldDataType();
        if (this$oldDataType == null ? other$oldDataType != null : !this$oldDataType.equals(other$oldDataType)) {
            return false;
        }
        String this$newDataType = this.getNewDataType();
        String other$newDataType = other.getNewDataType();
        return !(this$newDataType == null ? other$newDataType != null : !this$newDataType.equals(other$newDataType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ConvertDataType;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $oldDataType = this.getOldDataType();
        result = result * 59 + ($oldDataType == null ? 43 : $oldDataType.hashCode());
        String $newDataType = this.getNewDataType();
        result = result * 59 + ($newDataType == null ? 43 : $newDataType.hashCode());
        return result;
    }
}

