/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.marker.SearchResult;

public class LambdaBlockToExpression
extends Recipe {
    public String getDisplayName() {
        return "Simplify lambda blocks to expressions";
    }

    public String getDescription() {
        return "Single-line statement lambdas returning a value can be replaced with expression lambdas.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext executionContext) {
                return (J.CompilationUnit)SearchResult.found((Tree)cu);
            }
        }, (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.Lambda visitLambda(J.Lambda lambda, ExecutionContext executionContext) {
                List statements;
                J.Lambda l = super.visitLambda(lambda, (Object)executionContext);
                if (lambda.getBody() instanceof J.Block && (statements = ((J.Block)lambda.getBody()).getStatements()).size() == 1 && statements.get(0) instanceof J.Return) {
                    Space prefix = ((Statement)statements.get(0)).getPrefix();
                    if (prefix.getComments().isEmpty()) {
                        return l.withBody((J)((J.Return)statements.get(0)).getExpression());
                    }
                    return l.withBody(((J.Return)statements.get(0)).getExpression().withPrefix(prefix));
                }
                return l;
            }
        });
    }
}

