/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public class ReplaceValidateNotNullHavingVarargsWithObjectsRequireNonNull
extends Recipe {
    private static final MethodMatcher VALIDATE_NOTNULL = new MethodMatcher("org.apache.commons.lang3.Validate notNull(Object, String, Object[])");

    public String getDisplayName() {
        return "Replace `org.apache.commons.lang3.Validate#notNull` with `Objects#requireNonNull`";
    }

    public String getDescription() {
        return "Replace `org.apache.commons.lang3.Validate.notNull(Object, String, Object[])` with `Objects.requireNonNull(Object, String)`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(VALIDATE_NOTNULL), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext p) {
                J.MethodInvocation mi = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)p);
                if (!VALIDATE_NOTNULL.matches(mi)) {
                    return mi;
                }
                List arguments = mi.getArguments();
                String template = arguments.size() == 2 ? "Objects.requireNonNull(#{any()}, #{any(java.lang.String)})" : String.format("Objects.requireNonNull(#{any()}, () -> String.format(#{any(java.lang.String)}, %s))", String.join((CharSequence)", ", Collections.nCopies(arguments.size() - 2, "#{any()}")));
                this.maybeRemoveImport("org.apache.commons.lang3.Validate");
                this.maybeAddImport("java.util.Objects");
                mi = (J.MethodInvocation)JavaTemplate.builder((String)template).contextSensitive().imports(new String[]{"java.util.Objects"}).build().apply(this.updateCursor((Tree)mi), mi.getCoordinates().replace(), arguments.toArray());
                if (arguments.size() == 2) {
                    return this.maybeAutoFormat((J)mi, (J)mi.withArguments(ListUtils.map((List)mi.getArguments(), (a, b) -> (Expression)b.withPrefix(((Expression)arguments.get((int)a)).getPrefix()))), p);
                }
                Expression arg0 = (Expression)arguments.get(0);
                arguments.remove(0);
                J.Lambda lambda = (J.Lambda)mi.getArguments().get(1);
                J.MethodInvocation stringFormatMi = (J.MethodInvocation)lambda.getBody();
                stringFormatMi = stringFormatMi.withArguments(ListUtils.map((List)stringFormatMi.getArguments(), (a, b) -> (Expression)b.withPrefix(((Expression)arguments.get((int)a)).getPrefix())));
                lambda = (J.Lambda)this.maybeAutoFormat((J)lambda, (J)lambda.withBody((J)stringFormatMi), p);
                return this.maybeAutoFormat((J)mi, (J)mi.withArguments(Stream.of(arg0, lambda).collect(Collectors.toList())), p);
            }
        });
    }
}

