/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;

public class UnnecessaryExplicitTypeArguments
extends Recipe {
    public String getDisplayName() {
        return "Unnecessary explicit type arguments";
    }

    public String getDescription() {
        return "When explicit type arguments are inferrable by the compiler, they may be removed.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                if (m.getMethodType() != null) {
                    Object enclosing = this.getCursor().getParentTreeCursor().getValue();
                    JavaType enclosingType = null;
                    if (enclosing instanceof J.MethodInvocation) {
                        J.MethodInvocation enclosingMethod = (J.MethodInvocation)enclosing;
                        if (enclosingMethod.getMethodType() == null) {
                            return m;
                        }
                        if (!(enclosingMethod.getMethodType().getDeclaringType() instanceof JavaType.Class)) {
                            return m;
                        }
                        JavaType.Class declaringClass = (JavaType.Class)enclosingMethod.getMethodType().getDeclaringType();
                        if (declaringClass.getMethods().stream().filter(it -> it.getName().equals(enclosingMethod.getSimpleName())).count() > 1L) {
                            return m;
                        }
                        enclosingType = enclosingMethod.getType();
                    } else if (enclosing instanceof Expression) {
                        enclosingType = ((Expression)enclosing).getType();
                    } else if (enclosing instanceof NameTree) {
                        J.VariableDeclarations decl;
                        if (enclosing instanceof J.VariableDeclarations.NamedVariable && (decl = (J.VariableDeclarations)this.getCursor().getParentTreeCursor().getParentTreeCursor().getValue()).getTypeExpression() instanceof J.Identifier && "var".equals(((J.Identifier)decl.getTypeExpression()).getSimpleName())) {
                            return m;
                        }
                        enclosingType = ((NameTree)enclosing).getType();
                    } else if (enclosing instanceof J.Return) {
                        Object e = this.getCursor().dropParentUntil(p -> p instanceof J.MethodDeclaration || p instanceof J.Lambda || p.equals("root")).getValue();
                        if (e instanceof J.MethodDeclaration) {
                            J.MethodDeclaration methodDeclaration = (J.MethodDeclaration)e;
                            if (methodDeclaration.getReturnTypeExpression() != null) {
                                enclosingType = methodDeclaration.getReturnTypeExpression().getType();
                            }
                        } else if (e instanceof J.Lambda) {
                            enclosingType = ((J.Lambda)e).getType();
                        }
                    }
                    if (enclosingType != null && enclosingType.equals(m.getMethodType().getReturnType())) {
                        m = m.withTypeParameters(null);
                    }
                }
                return m;
            }
        };
    }
}

