/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;

public class UseSystemLineSeparator
extends Recipe {
    private static final MethodMatcher GET_PROPERTY = new MethodMatcher("java.lang.System getProperty(..)");
    private static final String LINE_SEPARATOR = "line.separator";

    public String getDisplayName() {
        return "Use `System.lineSeparator()`";
    }

    public String getDescription() {
        return "Replace calls to `System.getProperty(\"line.separator\")` with `System.lineSeparator()`.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(GET_PROPERTY), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation invocation = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                if (GET_PROPERTY.matches(method)) {
                    JavaTemplate template;
                    String param = "";
                    if (method.getArguments().size() == 1 && method.getArguments().get(0) instanceof J.Literal) {
                        Object value = ((J.Literal)method.getArguments().get(0)).getValue();
                        if (value == null) {
                            return method;
                        }
                        param = value.toString();
                    }
                    if (!UseSystemLineSeparator.LINE_SEPARATOR.equals(param)) {
                        return invocation;
                    }
                    if (method.getSelect() != null) {
                        template = JavaTemplate.builder((String)"#{any(java.lang.System)}.lineSeparator()").build();
                        return template.apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getSelect()});
                    }
                    this.maybeRemoveImport("java.lang.System.getProperty");
                    this.maybeAddImport("java.lang.System", "lineSeparator");
                    template = JavaTemplate.builder((String)"lineSeparator()").staticImports(new String[]{"java.lang.System.lineSeparator"}).build();
                    return template.apply(this.getCursor(), method.getCoordinates().replace(), new Object[0]);
                }
                return invocation;
            }
        });
    }
}

