/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;
import org.openrewrite.marker.SearchResult;

public class NoDoubleBraceInitialization
extends Recipe {
    private static final JavaType MAP_TYPE = JavaType.buildType((String)"java.util.Map");
    private static final JavaType LIST_TYPE = JavaType.buildType((String)"java.util.List");
    private static final JavaType SET_TYPE = JavaType.buildType((String)"java.util.Set");

    public String getDisplayName() {
        return "No double brace initialization";
    }

    public String getDescription() {
        return "Replace `List`, `Map`, and `Set` double brace initialization with an initialization block.";
    }

    public Set<String> getTags() {
        return new LinkedHashSet<String>(Arrays.asList("RSPEC-1171", "RSPEC-3599"));
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(30L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Map", Boolean.valueOf(false)), new UsesType("java.util.List", Boolean.valueOf(false)), new UsesType("java.util.Set", Boolean.valueOf(false))}), (TreeVisitor)new NoDoubleBraceInitializationVisitor());
    }

    private static class NoDoubleBraceInitializationVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private NoDoubleBraceInitializationVisitor() {
        }

        private boolean isSupportedDoubleBraceInitialization(J.NewClass nc) {
            if (this.getCursor().getParent() == null || this.getCursor().getParent().firstEnclosing(J.class) instanceof J.MethodInvocation || this.getCursor().getParent().firstEnclosing(J.class) instanceof J.NewClass) {
                return false;
            }
            if (nc.getBody() != null && !nc.getBody().getStatements().isEmpty() && nc.getBody().getStatements().size() == 1 && nc.getBody().getStatements().get(0) instanceof J.Block && this.getCursor().getParent(3) != null) {
                return TypeUtils.isAssignableTo((JavaType)MAP_TYPE, (JavaType)nc.getType()) || TypeUtils.isAssignableTo((JavaType)LIST_TYPE, (JavaType)nc.getType()) || TypeUtils.isAssignableTo((JavaType)SET_TYPE, (JavaType)nc.getType());
            }
            return false;
        }

        public J.NewClass visitNewClass(J.NewClass newClass, ExecutionContext executionContext) {
            J.NewClass nc = super.visitNewClass(newClass, (Object)executionContext);
            this.updateCursor((Tree)nc);
            if (this.isSupportedDoubleBraceInitialization(newClass)) {
                boolean maybeMistakenlyMissedAddingElement;
                Cursor parentBlockCursor = this.getCursor().dropParentUntil(J.Block.class::isInstance);
                J.VariableDeclarations.NamedVariable var = (J.VariableDeclarations.NamedVariable)this.getCursor().firstEnclosing(J.VariableDeclarations.NamedVariable.class);
                J.Block secondBlock = (J.Block)nc.getBody().getStatements().get(0);
                List<Statement> initStatements = secondBlock.getStatements();
                boolean bl = maybeMistakenlyMissedAddingElement = !initStatements.isEmpty() && initStatements.stream().allMatch(statement -> statement instanceof J.NewClass);
                if (maybeMistakenlyMissedAddingElement) {
                    JavaType newClassType = nc.getType();
                    String addToCollectionMethod = TypeUtils.isAssignableTo((JavaType)MAP_TYPE, (JavaType)newClassType) ? "put()" : "add()";
                    return nc.withBody(AddWarningMessage.addWarningComment(nc.getBody(), addToCollectionMethod));
                }
                boolean hasMethodInvocationInDoubleBrace = FindMethodInvocationInDoubleBrace.find((J)secondBlock);
                if (hasMethodInvocationInDoubleBrace && var != null && parentBlockCursor.getParent() != null) {
                    if (parentBlockCursor.getParent().getValue() instanceof J.ClassDeclaration) {
                        JavaType.FullyQualified fq = TypeUtils.asFullyQualified((JavaType)nc.getType());
                        if (fq != null && fq.getSupertype() != null) {
                            Cursor varDeclsCursor = this.getCursor().dropParentUntil(parent -> parent instanceof J.VariableDeclarations);
                            Cursor namedVarCursor = this.getCursor().dropParentUntil(J.VariableDeclarations.NamedVariable.class::isInstance);
                            namedVarCursor.putMessage("DROP_INITIALIZER", (Object)Boolean.TRUE);
                            fq = fq.getSupertype();
                            String newInitializer = " new " + fq.getClassName() + "<>();";
                            JavaTemplate template = JavaTemplate.builder((String)newInitializer).imports(new String[]{fq.getFullyQualifiedName()}).build();
                            nc = (J.NewClass)template.apply(this.getCursor(), nc.getCoordinates().replace(), new Object[0]);
                            initStatements = this.addSelectToInitStatements(initStatements, var.getName(), executionContext);
                            initStatements.add(0, (Statement)new J.Assignment(UUID.randomUUID(), Space.EMPTY, Markers.EMPTY, (Expression)var.getName().withId(UUID.randomUUID()), JLeftPadded.build((Object)nc), (JavaType)fq));
                            ((HashMap)parentBlockCursor.computeMessageIfAbsent("INIT_STATEMENTS", v -> new HashMap())).put((Statement)varDeclsCursor.getValue(), initStatements);
                        }
                    } else if (parentBlockCursor.getParent().getValue() instanceof J.MethodDeclaration) {
                        initStatements = this.addSelectToInitStatements(initStatements, var.getName(), executionContext);
                        Cursor varDeclsCursor = this.getCursor().dropParentUntil(parent -> parent instanceof J.VariableDeclarations);
                        ((HashMap)parentBlockCursor.computeMessageIfAbsent("METHOD_DECL_STATEMENTS", v -> new HashMap())).put((Statement)varDeclsCursor.getValue(), initStatements);
                        nc = nc.withBody(null);
                    }
                }
            }
            return nc;
        }

        private List<Statement> addSelectToInitStatements(List<Statement> statements, J.Identifier identifier, ExecutionContext ctx) {
            AddSelectVisitor selectVisitor = new AddSelectVisitor(identifier);
            ArrayList<Statement> statementList = new ArrayList<Statement>();
            for (Statement statement : statements) {
                statementList.add((Statement)selectVisitor.visit((Tree)statement, ctx));
            }
            return statementList;
        }

        public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, ExecutionContext executionContext) {
            J.VariableDeclarations.NamedVariable var = super.visitVariable(variable, (Object)executionContext);
            if (this.getCursor().pollMessage("DROP_INITIALIZER") != null) {
                var = var.withInitializer(null);
            }
            return var;
        }

        public J.Block visitBlock(J.Block block, ExecutionContext ctx) {
            J.Block bl;
            block3: {
                Map methodInitStatements;
                block2: {
                    bl = super.visitBlock(block, (Object)ctx);
                    Map initStatements = (Map)this.getCursor().pollMessage("INIT_STATEMENTS");
                    methodInitStatements = (Map)this.getCursor().pollMessage("METHOD_DECL_STATEMENTS");
                    if (initStatements == null) break block2;
                    for (Map.Entry objectListEntry : initStatements.entrySet()) {
                        Object statement = objectListEntry.getKey();
                        int statementIndex = bl.getStatements().indexOf(statement);
                        if (statementIndex <= -1) continue;
                        JRightPadded isStatic = objectListEntry.getKey() instanceof J.VariableDeclarations && J.Modifier.hasModifier((Collection)((J.VariableDeclarations)statement).getModifiers(), (J.Modifier.Type)J.Modifier.Type.Static) ? JRightPadded.build((Object)true).withAfter(Space.format((String)" ")) : JRightPadded.build((Object)false);
                        J.Block initBlock = new J.Block(Tree.randomId(), Space.EMPTY, Markers.EMPTY, isStatic, ((List)objectListEntry.getValue()).stream().map(JRightPadded::build).collect(Collectors.toList()), Space.EMPTY);
                        bl = (J.Block)this.maybeAutoFormat((J)bl, (J)bl.withStatements(ListUtils.insertAll((List)bl.getStatements(), (int)(statementIndex + 1), Collections.singletonList(initBlock))), (J)initBlock, ctx, this.getCursor().getParent(2));
                    }
                    break block3;
                }
                if (methodInitStatements == null) break block3;
                for (Map.Entry objectListEntry : methodInitStatements.entrySet()) {
                    int statementIndex = bl.getStatements().indexOf(objectListEntry.getKey());
                    if (statementIndex <= -1) continue;
                    bl = (J.Block)this.maybeAutoFormat((J)bl, (J)bl.withStatements(ListUtils.insertAll((List)bl.getStatements(), (int)(statementIndex + 1), (List)((List)objectListEntry.getValue()))), (J)((List)objectListEntry.getValue()).get(((List)objectListEntry.getValue()).size() - 1), ctx, this.getCursor().getParent());
                }
            }
            return bl;
        }

        private static class AddSelectVisitor
        extends JavaIsoVisitor<ExecutionContext> {
            private final J.Identifier identifier;

            public AddSelectVisitor(J.Identifier identifier) {
                this.identifier = identifier;
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)executionContext);
                if (mi.getMethodType() != null && this.identifier.getFieldType() != null && mi.getSelect() == null || mi.getSelect() instanceof J.Identifier && "this".equals(((J.Identifier)mi.getSelect()).getSimpleName())) {
                    if (this.identifier.getFieldType() == null) {
                        return mi;
                    }
                    JavaType rawFieldType = this.identifier.getFieldType().getType();
                    Object object = rawFieldType = rawFieldType instanceof JavaType.Parameterized ? ((JavaType.Parameterized)rawFieldType).getType() : rawFieldType;
                    if (mi.getMethodType() == null) {
                        return mi;
                    }
                    JavaType.FullyQualified rawMethodDeclaringType = mi.getMethodType().getDeclaringType();
                    JavaType.FullyQualified fullyQualified = rawMethodDeclaringType = rawMethodDeclaringType instanceof JavaType.Parameterized ? ((JavaType.Parameterized)rawMethodDeclaringType).getType() : rawMethodDeclaringType;
                    if (TypeUtils.isAssignableTo((JavaType)rawFieldType, (JavaType)rawMethodDeclaringType)) {
                        return mi.withSelect((Expression)this.identifier);
                    }
                }
                return mi;
            }
        }
    }

    private static class FindMethodInvocationInDoubleBrace
    extends JavaIsoVisitor<AtomicBoolean> {
        private FindMethodInvocationInDoubleBrace() {
        }

        static boolean find(J j) {
            return ((AtomicBoolean)new FindMethodInvocationInDoubleBrace().reduce((Tree)j, new AtomicBoolean())).get();
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, AtomicBoolean atomicBoolean) {
            if (atomicBoolean.get() || method.getMethodType() == null) {
                return method;
            }
            JavaType.FullyQualified declaring = method.getMethodType().getDeclaringType();
            if (TypeUtils.isAssignableTo((JavaType)MAP_TYPE, (JavaType)declaring) || TypeUtils.isAssignableTo((JavaType)LIST_TYPE, (JavaType)declaring) || TypeUtils.isAssignableTo((JavaType)SET_TYPE, (JavaType)declaring)) {
                atomicBoolean.set(true);
                return method;
            }
            return super.visitMethodInvocation(method, (Object)atomicBoolean);
        }
    }

    private static class AddWarningMessage
    extends JavaIsoVisitor<String> {
        private AddWarningMessage() {
        }

        static <T extends J> T addWarningComment(T nc, String methodName) {
            return (T)((J)new AddWarningMessage().visitNonNull((Tree)nc, methodName));
        }

        public J.NewClass visitNewClass(J.NewClass newClass, String methodName) {
            String comment = "Did you mean to invoke " + methodName + " method to the collection?";
            return (J.NewClass)SearchResult.found((Tree)newClass, (String)comment);
        }
    }
}

