/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public class UseCollectionInterfaces
extends Recipe {
    public static Map<String, String> rspecRulesReplaceTypeMap = new HashMap<String, String>();

    public String getDisplayName() {
        return "Use `Collection` interfaces";
    }

    public String getDescription() {
        return "Use `Deque`, `List`, `Map`, `ConcurrentMap`, `Queue`, and `Set` instead of implemented collections. Replaces the return type of public method declarations and the variable type public variable declarations.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1319");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(10L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof JavaSourceFile) {
                    JavaSourceFile cu = (JavaSourceFile)Objects.requireNonNull(tree);
                    for (JavaType type : cu.getTypesInUse().getTypesInUse()) {
                        JavaType.FullyQualified fq = TypeUtils.asFullyQualified((JavaType)type);
                        if (fq == null || !rspecRulesReplaceTypeMap.containsKey(fq.getFullyQualifiedName())) continue;
                        return (J)super.visit((Tree)cu, (Object)ctx);
                    }
                }
                return (J)super.visit(tree, (Object)ctx);
            }

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext executionContext) {
                JavaType.FullyQualified newType;
                JavaType.FullyQualified originalType;
                J.MethodDeclaration m = super.visitMethodDeclaration(method, (Object)executionContext);
                if ((m.hasModifier(J.Modifier.Type.Public) || m.hasModifier(J.Modifier.Type.Private) || m.getModifiers().isEmpty()) && m.getReturnTypeExpression() != null && (originalType = TypeUtils.asFullyQualified((JavaType)m.getReturnTypeExpression().getType())) != null && rspecRulesReplaceTypeMap.containsKey(originalType.getFullyQualifiedName()) && (newType = TypeUtils.asFullyQualified((JavaType)JavaType.buildType((String)rspecRulesReplaceTypeMap.get(originalType.getFullyQualifiedName())))) != null) {
                    J.Identifier typeExpression;
                    this.maybeRemoveImport(originalType);
                    this.maybeAddImport(newType);
                    if (m.getReturnTypeExpression() instanceof J.Identifier) {
                        typeExpression = new J.Identifier(Tree.randomId(), m.getReturnTypeExpression().getPrefix(), Markers.EMPTY, Collections.emptyList(), newType.getClassName(), (JavaType)newType, null);
                    } else {
                        J.ParameterizedType parameterizedType = (J.ParameterizedType)m.getReturnTypeExpression();
                        J.Identifier returnType = new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), newType.getClassName(), (JavaType)newType, null);
                        JavaType.Parameterized javaType = (JavaType.Parameterized)parameterizedType.getType();
                        typeExpression = parameterizedType.withClazz((NameTree)returnType).withType((JavaType)(javaType != null ? javaType.withType(newType) : new JavaType.Parameterized(null, newType, null)));
                    }
                    m = m.withReturnTypeExpression((TypeTree)typeExpression);
                }
                return m;
            }

            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext executionContext) {
                J.VariableDeclarations mv = super.visitVariableDeclarations(multiVariable, (Object)executionContext);
                JavaType.FullyQualified originalType = TypeUtils.asFullyQualified((JavaType)mv.getType());
                if ((mv.hasModifier(J.Modifier.Type.Public) || mv.hasModifier(J.Modifier.Type.Private) || mv.getModifiers().isEmpty()) && originalType != null && rspecRulesReplaceTypeMap.containsKey(originalType.getFullyQualifiedName())) {
                    if (mv.getTypeExpression() instanceof J.Identifier && "var".equals(((J.Identifier)mv.getTypeExpression()).getSimpleName())) {
                        return mv;
                    }
                    JavaType.FullyQualified newType = TypeUtils.asFullyQualified((JavaType)JavaType.buildType((String)rspecRulesReplaceTypeMap.get(originalType.getFullyQualifiedName())));
                    if (newType != null) {
                        J.Identifier typeExpression;
                        this.maybeRemoveImport(originalType);
                        this.maybeAddImport(newType);
                        if (mv.getTypeExpression() == null) {
                            typeExpression = null;
                        } else if (mv.getTypeExpression() instanceof J.Identifier) {
                            typeExpression = new J.Identifier(Tree.randomId(), mv.getTypeExpression().getPrefix(), Markers.EMPTY, Collections.emptyList(), newType.getClassName(), (JavaType)newType, null);
                        } else {
                            J.ParameterizedType parameterizedType = (J.ParameterizedType)mv.getTypeExpression();
                            J.Identifier returnType = new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), newType.getClassName(), (JavaType)newType, null);
                            JavaType.Parameterized javaType = (JavaType.Parameterized)parameterizedType.getType();
                            typeExpression = parameterizedType.withClazz((NameTree)returnType).withType((JavaType)(javaType != null ? javaType.withType(newType) : new JavaType.Parameterized(null, newType, null)));
                        }
                        mv = mv.withTypeExpression(typeExpression);
                        mv = mv.withVariables(ListUtils.map((List)mv.getVariables(), var -> {
                            JavaType.FullyQualified varType = TypeUtils.asFullyQualified((JavaType)var.getType());
                            if (varType != null && !varType.equals(newType)) {
                                return var.withType((JavaType)newType).withName(var.getName().withType((JavaType)newType));
                            }
                            return var;
                        }));
                    }
                }
                return mv;
            }
        };
    }

    static {
        rspecRulesReplaceTypeMap.put("java.util.ArrayDeque", "java.util.Deque");
        rspecRulesReplaceTypeMap.put("java.util.concurrent.ConcurrentLinkedDeque", "java.util.Deque");
        rspecRulesReplaceTypeMap.put("java.util.AbstractList", "java.util.List");
        rspecRulesReplaceTypeMap.put("java.util.AbstractSequentialList", "java.util.List");
        rspecRulesReplaceTypeMap.put("java.util.ArrayList", "java.util.List");
        rspecRulesReplaceTypeMap.put("java.util.concurrent.CopyOnWriteArrayList", "java.util.List");
        rspecRulesReplaceTypeMap.put("java.util.AbstractMap", "java.util.Map");
        rspecRulesReplaceTypeMap.put("java.util.EnumMap", "java.util.Map");
        rspecRulesReplaceTypeMap.put("java.util.HashMap", "java.util.Map");
        rspecRulesReplaceTypeMap.put("java.util.Hashtable", "java.util.Map");
        rspecRulesReplaceTypeMap.put("java.util.IdentityHashMap", "java.util.Map");
        rspecRulesReplaceTypeMap.put("java.util.LinkedHashMap", "java.util.Map");
        rspecRulesReplaceTypeMap.put("java.util.WeakHashMap", "java.util.Map");
        rspecRulesReplaceTypeMap.put("java.util.concurrent.ConcurrentHashMap", "java.util.concurrent.ConcurrentMap");
        rspecRulesReplaceTypeMap.put("java.util.concurrent.ConcurrentSkipListMap", "java.util.concurrent.ConcurrentMap");
        rspecRulesReplaceTypeMap.put("java.util.AbstractQueue", "java.util.Queue");
        rspecRulesReplaceTypeMap.put("java.util.concurrent.ConcurrentLinkedQueue", "java.util.Queue");
        rspecRulesReplaceTypeMap.put("java.util.AbstractSet", "java.util.Set");
        rspecRulesReplaceTypeMap.put("java.util.EnumSet", "java.util.Set");
        rspecRulesReplaceTypeMap.put("java.util.HashSet", "java.util.Set");
        rspecRulesReplaceTypeMap.put("java.util.LinkedHashSet", "java.util.Set");
        rspecRulesReplaceTypeMap.put("java.util.concurrent.CopyOnWriteArraySet", "java.util.Set");
    }
}

