/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public class MultipleVariableDeclarationsVisitor
extends JavaIsoVisitor<ExecutionContext> {
    public J.Block visitBlock(J.Block block, ExecutionContext ctx) {
        J.Block b = super.visitBlock(block, (Object)ctx);
        return b.withStatements(ListUtils.flatMap((List)b.getStatements(), statement -> {
            if (!(statement instanceof J.VariableDeclarations)) {
                return statement;
            }
            J.VariableDeclarations mv = (J.VariableDeclarations)statement;
            if (mv.getVariables().size() <= 1) {
                return mv;
            }
            ArrayList<J.VariableDeclarations> newDecls = new ArrayList<J.VariableDeclarations>(mv.getVariables().size());
            for (int i = 0; i < mv.getVariables().size(); ++i) {
                J.VariableDeclarations.NamedVariable nv = (J.VariableDeclarations.NamedVariable)mv.getVariables().get(i);
                List dimensions = ListUtils.concatAll((List)mv.getDimensionsBeforeName(), (List)nv.getDimensionsAfterName());
                nv = nv.withDimensionsAfterName(Collections.emptyList()).withPrefix(Space.EMPTY);
                J.VariableDeclarations vd = new J.VariableDeclarations(Tree.randomId(), Space.EMPTY, Markers.EMPTY, mv.getLeadingAnnotations(), mv.getModifiers(), mv.getTypeExpression(), mv.getVarargs(), dimensions, Collections.singletonList(JRightPadded.build((Object)nv)));
                if (i == 0) {
                    vd = (J.VariableDeclarations)vd.withComments(mv.getComments()).withPrefix(mv.getPrefix());
                }
                vd = (J.VariableDeclarations)this.autoFormat((J)vd, ctx, this.getCursor());
                newDecls.add(vd);
            }
            return newDecls;
        }));
    }
}

