/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.NameCaseConvention;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;
import org.openrewrite.staticanalysis.RenameToCamelCase;

public class RenamePrivateFieldsToCamelCase
extends Recipe {
    public String getDisplayName() {
        return "Reformat private field names to camelCase";
    }

    public String getDescription() {
        return "Reformat private field names to camelCase to comply with Java naming convention. The recipe will not rename fields with default, protected or public access modifiers.The recipe will not rename private constants.The first character is set to lower case and existing capital letters are preserved. Special characters that are allowed in java field names `$` and `_` are removed. If a special character is removed the next valid alphanumeric will be capitalized. The recipe will not rename a field if the result already exists in the class, conflicts with a java reserved keyword, or the result is blank.";
    }

    public Set<String> getTags() {
        return new LinkedHashSet<String>(Arrays.asList("RSPEC-116", "RSPEC-3008"));
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new RenameToCamelCase(){

            @Override
            protected boolean shouldRename(Set<String> hasNameKey, J.VariableDeclarations.NamedVariable variable, String toName) {
                if (toName.isEmpty() || !Character.isAlphabetic(toName.charAt(0))) {
                    return false;
                }
                return !hasNameKey.contains(toName) && !hasNameKey.contains(variable.getSimpleName());
            }

            public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, ExecutionContext ctx) {
                Cursor parentScope = this.getCursorToParentScope(this.getCursor());
                JavaType.Variable type = variable.getVariableType();
                if (parentScope.getParent() != null && parentScope.getParent().getValue() instanceof J.ClassDeclaration && !(parentScope.getValue() instanceof J.ClassDeclaration) && type != null && type.hasFlags(new Flag[]{Flag.Private}) && !type.hasFlags(new Flag[]{Flag.Static, Flag.Final}) && !((J.ClassDeclaration)parentScope.getParent().getValue()).getType().getFullyQualifiedName().contains("$") && !NameCaseConvention.LOWER_CAMEL.matches(variable.getSimpleName())) {
                    if (variable.getSimpleName().toUpperCase(Locale.getDefault()).equals(variable.getSimpleName()) && type.hasFlags(new Flag[]{Flag.Private, Flag.Final}) && !type.hasFlags(new Flag[]{Flag.Static})) {
                        HashSet<Flag> flags = new HashSet<Flag>(type.getFlags());
                        flags.add(Flag.Static);
                        this.getCursor().getParentTreeCursor().putMessage("ADD_STATIC", (Object)true);
                        return variable.withVariableType(type.withFlags(flags));
                    }
                    String toName = NameCaseConvention.LOWER_CAMEL.format(variable.getSimpleName());
                    this.renameVariable(variable, toName);
                } else {
                    this.hasNameKey(variable.getSimpleName());
                }
                return super.visitVariable(variable, (Object)ctx);
            }

            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
                J.VariableDeclarations vds = super.visitVariableDeclarations(multiVariable, (Object)ctx);
                if (((Boolean)this.getCursor().getMessage("ADD_STATIC", (Object)false)).booleanValue()) {
                    return vds.withModifiers(ListUtils.insert((List)vds.getModifiers(), (Object)new J.Modifier(Tree.randomId(), Space.format((String)" "), Markers.EMPTY, "static", J.Modifier.Type.Static, Collections.emptyList()), (int)1));
                }
                return vds;
            }

            private Cursor getCursorToParentScope(Cursor cursor) {
                return cursor.dropParentUntil(is -> is instanceof J.ClassDeclaration || is instanceof J.Block || is instanceof SourceFile);
            }
        };
    }
}

