/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.Collections;
import java.util.Objects;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.style.EqualsAvoidsNullStyle;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public final class EqualsAvoidsNullVisitor<P>
extends JavaVisitor<P> {
    private static final MethodMatcher EQUALS = new MethodMatcher("java.lang.String equals(java.lang.Object)");
    private static final MethodMatcher EQUALS_IGNORE_CASE = new MethodMatcher("java.lang.String equalsIgnoreCase(java.lang.String)");
    private static final MethodMatcher COMPARE_TO = new MethodMatcher("java.lang.String compareTo(java.lang.String)");
    private static final MethodMatcher COMPARE_TO_IGNORE_CASE = new MethodMatcher("java.lang.String compareToIgnoreCase(java.lang.String)");
    private static final MethodMatcher CONTENT_EQUALS = new MethodMatcher("java.lang.String contentEquals(java.lang.CharSequence)");
    private final EqualsAvoidsNullStyle style;

    public J visitMethodInvocation(J.MethodInvocation method, P p) {
        J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, p);
        if (m.getSelect() != null && !(m.getSelect() instanceof J.Literal) && m.getArguments().get(0) instanceof J.Literal && this.isStringComparisonMethod(m)) {
            return this.literalsFirstInComparisonsBinaryCheck(m, this.getCursor().getParentTreeCursor().getValue());
        }
        return m;
    }

    private boolean isStringComparisonMethod(J.MethodInvocation methodInvocation) {
        return EQUALS.matches((MethodCall)methodInvocation) || this.style.getIgnoreEqualsIgnoreCase() == false && EQUALS_IGNORE_CASE.matches((MethodCall)methodInvocation) || COMPARE_TO.matches((MethodCall)methodInvocation) || COMPARE_TO_IGNORE_CASE.matches((MethodCall)methodInvocation) || CONTENT_EQUALS.matches((MethodCall)methodInvocation);
    }

    private Expression literalsFirstInComparisonsBinaryCheck(J.MethodInvocation m, P parent) {
        if (parent instanceof J.Binary) {
            this.handleBinaryExpression(m, (J.Binary)parent);
        }
        return EqualsAvoidsNullVisitor.getExpression(m, (Expression)m.getArguments().get(0));
    }

    private static Expression getExpression(J.MethodInvocation m, Expression firstArgument) {
        return firstArgument.getType() == JavaType.Primitive.Null ? EqualsAvoidsNullVisitor.literalsFirstInComparisonsNull(m, firstArgument) : EqualsAvoidsNullVisitor.literalsFirstInComparisons(m, firstArgument);
    }

    private static J.Binary literalsFirstInComparisonsNull(J.MethodInvocation m, Expression firstArgument) {
        return new J.Binary(Tree.randomId(), m.getPrefix(), Markers.EMPTY, Objects.requireNonNull(m.getSelect()), JLeftPadded.build((Object)J.Binary.Type.Equal).withBefore(Space.SINGLE_SPACE), (Expression)firstArgument.withPrefix(Space.SINGLE_SPACE), (JavaType)JavaType.Primitive.Boolean);
    }

    private static J.MethodInvocation literalsFirstInComparisons(J.MethodInvocation m, Expression firstArgument) {
        return m.withSelect((Expression)firstArgument.withPrefix(Objects.requireNonNull(m.getSelect()).getPrefix())).withArguments(Collections.singletonList((Expression)m.getSelect().withPrefix(Space.EMPTY)));
    }

    private void handleBinaryExpression(J.MethodInvocation m, J.Binary binary) {
        J.Binary potentialNullCheck;
        if (binary.getOperator() == J.Binary.Type.And && binary.getLeft() instanceof J.Binary && (this.isNullLiteral((potentialNullCheck = (J.Binary)binary.getLeft()).getLeft()) && this.matchesSelect(potentialNullCheck.getRight(), Objects.requireNonNull(m.getSelect())) || this.isNullLiteral(potentialNullCheck.getRight()) && this.matchesSelect(potentialNullCheck.getLeft(), Objects.requireNonNull(m.getSelect())))) {
            this.doAfterVisit((TreeVisitor)new RemoveUnnecessaryNullCheck(binary));
        }
    }

    private boolean isNullLiteral(Expression expression) {
        return expression instanceof J.Literal && ((J.Literal)expression).getType() == JavaType.Primitive.Null;
    }

    private boolean matchesSelect(Expression expression, Expression select) {
        return expression.printTrimmed(this.getCursor()).replaceAll("\\s", "").equals(select.printTrimmed(this.getCursor()).replaceAll("\\s", ""));
    }

    @Generated
    public EqualsAvoidsNullVisitor(EqualsAvoidsNullStyle style) {
        this.style = style;
    }

    @Generated
    public EqualsAvoidsNullStyle getStyle() {
        return this.style;
    }

    @Generated
    public String toString() {
        return "EqualsAvoidsNullVisitor(style=" + this.getStyle() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EqualsAvoidsNullVisitor)) {
            return false;
        }
        EqualsAvoidsNullVisitor other = (EqualsAvoidsNullVisitor)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        EqualsAvoidsNullStyle this$style = this.getStyle();
        EqualsAvoidsNullStyle other$style = other.getStyle();
        return !(this$style == null ? other$style != null : !this$style.equals(other$style));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EqualsAvoidsNullVisitor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EqualsAvoidsNullStyle $style = this.getStyle();
        result = result * 59 + ($style == null ? 43 : $style.hashCode());
        return result;
    }

    private static class RemoveUnnecessaryNullCheck<P>
    extends JavaVisitor<P> {
        private final J.Binary scope;
        boolean done;

        public RemoveUnnecessaryNullCheck(J.Binary scope) {
            this.scope = scope;
        }

        public @Nullable J visit(@Nullable Tree tree, P p) {
            if (this.done) {
                return (J)tree;
            }
            return (J)super.visit(tree, p);
        }

        public J visitBinary(J.Binary binary, P p) {
            if (this.scope.isScope((Tree)binary)) {
                this.done = true;
                return binary.getRight().withPrefix(Space.EMPTY);
            }
            return super.visitBinary(binary, p);
        }
    }
}

