/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.function.BiPredicate;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;

public class RemoveMethodCallVisitor<P>
extends JavaIsoVisitor<P> {
    private final MethodMatcher methodMatcher;
    private final BiPredicate<Integer, Expression> argumentPredicate;

    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable J.NewClass visitNewClass(J.NewClass newClass, P p) {
        if (this.methodMatcher.matches((MethodCall)newClass) && this.predicateMatchesAllArguments((MethodCall)newClass) && this.isStatementInParentBlock((Statement)newClass)) {
            if (newClass.getMethodType() != null) {
                this.maybeRemoveImport(newClass.getMethodType().getDeclaringType());
            }
            return null;
        }
        return super.visitNewClass(newClass, p);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, P p) {
        if (this.methodMatcher.matches((MethodCall)method) && this.predicateMatchesAllArguments((MethodCall)method)) {
            if (this.isStatementInParentBlock((Statement)method)) {
                if (method.getMethodType() != null) {
                    this.maybeRemoveImport(method.getMethodType().getDeclaringType());
                }
                return null;
            }
            if (method.getSelect() instanceof J.MethodInvocation && TypeUtils.isOfType((JavaType)method.getType(), (JavaType)method.getSelect().getType())) {
                return super.visitMethodInvocation((J.MethodInvocation)method.getSelect(), p);
            }
        }
        return super.visitMethodInvocation(method, p);
    }

    private boolean predicateMatchesAllArguments(MethodCall method) {
        for (int i = 0; i < method.getArguments().size(); ++i) {
            if (this.argumentPredicate.test(i, (Expression)method.getArguments().get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isStatementInParentBlock(Statement method) {
        J.Block parentBlock = (J.Block)this.getCursor().firstEnclosing(J.Block.class);
        return parentBlock == null || parentBlock.getStatements().contains(method);
    }

    @Generated
    public RemoveMethodCallVisitor(MethodMatcher methodMatcher, BiPredicate<Integer, Expression> argumentPredicate) {
        this.methodMatcher = methodMatcher;
        this.argumentPredicate = argumentPredicate;
    }
}

