/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.service.AnnotationService;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.kotlin.tree.K;

public final class MissingOverrideAnnotation
extends Recipe {
    @Option(displayName="Ignore methods in anonymous classes", description="When enabled, ignore missing annotations on methods which override methods when the class definition is within an anonymous class.", required=false)
    @Nullable
    private final Boolean ignoreAnonymousClassMethods;

    public String getDisplayName() {
        return "Add missing `@Override` to overriding and implementing methods";
    }

    public String getDescription() {
        return "Adds `@Override` to methods overriding superclass methods or implementing interface methods. Annotating methods improves readability by showing the author's intent to override. Additionally, when annotated, the compiler will emit an error when a signature of the overridden method does not match the superclass method.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1161");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MissingOverrideAnnotationVisitor();
    }

    public MissingOverrideAnnotation(Boolean ignoreAnonymousClassMethods) {
        this.ignoreAnonymousClassMethods = ignoreAnonymousClassMethods;
    }

    public Boolean getIgnoreAnonymousClassMethods() {
        return this.ignoreAnonymousClassMethods;
    }

    public String toString() {
        return "MissingOverrideAnnotation(ignoreAnonymousClassMethods=" + this.getIgnoreAnonymousClassMethods() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MissingOverrideAnnotation)) {
            return false;
        }
        MissingOverrideAnnotation other = (MissingOverrideAnnotation)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$ignoreAnonymousClassMethods = this.getIgnoreAnonymousClassMethods();
        Boolean other$ignoreAnonymousClassMethods = other.getIgnoreAnonymousClassMethods();
        return !(this$ignoreAnonymousClassMethods == null ? other$ignoreAnonymousClassMethods != null : !((Object)this$ignoreAnonymousClassMethods).equals(other$ignoreAnonymousClassMethods));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MissingOverrideAnnotation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $ignoreAnonymousClassMethods = this.getIgnoreAnonymousClassMethods();
        result = result * 59 + ($ignoreAnonymousClassMethods == null ? 43 : ((Object)$ignoreAnonymousClassMethods).hashCode());
        return result;
    }

    private class MissingOverrideAnnotationVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final AnnotationMatcher OVERRIDE_ANNOTATION = new AnnotationMatcher("@java.lang.Override");

        private MissingOverrideAnnotationVisitor() {
        }

        public boolean isAcceptable(SourceFile sourceFile, ExecutionContext ctx) {
            return super.isAcceptable(sourceFile, (Object)ctx) && !(sourceFile instanceof K.CompilationUnit);
        }

        private Cursor getCursorToParentScope(Cursor cursor) {
            return cursor.dropParentUntil(is -> is instanceof J.NewClass || is instanceof J.ClassDeclaration);
        }

        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
            if (!(method.hasModifier(J.Modifier.Type.Static) || method.isConstructor() || ((AnnotationService)this.service(AnnotationService.class)).matches(this.getCursor(), this.OVERRIDE_ANNOTATION) || !TypeUtils.isOverride((JavaType.Method)method.getMethodType()) || Boolean.TRUE.equals(MissingOverrideAnnotation.this.ignoreAnonymousClassMethods) && this.getCursorToParentScope(this.getCursor()).getValue() instanceof J.NewClass)) {
                method = (J.MethodDeclaration)JavaTemplate.apply((String)"@Override", (Cursor)this.getCursor(), (JavaCoordinates)method.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), (Object[])new Object[0]);
            }
            return super.visitMethodDeclaration(method, (Object)ctx);
        }
    }
}

