/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class FixStringFormatExpressions
extends Recipe {
    public String getDisplayName() {
        return "Fix `String#format` and `String#formatted` expressions";
    }

    public String getDescription() {
        return "Fix `String#format` and `String#formatted` expressions by replacing `\\n` newline characters with `%n` and removing any unused arguments. Note this recipe is scoped to only transform format expressions which do not specify the argument index.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-3457");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.of(5L, ChronoUnit.MINUTES);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod(new MethodMatcher("java.lang.String format(..)")), new UsesMethod(new MethodMatcher("java.lang.String formatted(..)"))}), (TreeVisitor)new FixPrintfExpressionsVisitor());
    }

    private static class FixPrintfExpressionsVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final String formatSpecifier = "%(\\d+\\$)?([-#+ 0,(<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])";
        private final Pattern fsPattern = Pattern.compile("%(\\d+\\$)?([-#+ 0,(<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])");
        MethodMatcher sFormatMatcher = new MethodMatcher("java.lang.String format(..)");
        MethodMatcher sFormattedMatcher = new MethodMatcher("java.lang.String formatted(..)");

        private FixPrintfExpressionsVisitor() {
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
            if (this.sFormatMatcher.matches((MethodCall)mi) || this.sFormattedMatcher.matches((MethodCall)mi)) {
                int argIndex;
                boolean isStringFormattedExpression = false;
                J.Literal fmtArg = null;
                if (this.sFormatMatcher.matches((MethodCall)mi) && mi.getArguments().get(0) instanceof J.Literal) {
                    fmtArg = (J.Literal)mi.getArguments().get(0);
                } else if (this.sFormattedMatcher.matches((MethodCall)mi) && mi.getSelect() instanceof J.Literal) {
                    fmtArg = (J.Literal)mi.getSelect();
                    isStringFormattedExpression = true;
                }
                if (fmtArg == null || fmtArg.getValue() == null || fmtArg.getValueSource() == null) {
                    return mi;
                }
                mi = isStringFormattedExpression ? mi.withSelect(FixPrintfExpressionsVisitor.replaceNewLineChars(mi.getSelect())) : mi.withArguments(ListUtils.mapFirst((List)mi.getArguments(), FixPrintfExpressionsVisitor::replaceNewLineChars));
                String val = (String)fmtArg.getValue();
                Matcher m = this.fsPattern.matcher(val);
                int n = argIndex = isStringFormattedExpression ? 0 : 1;
                while (m.find()) {
                    if (m.group(1) != null || m.group(2).contains("<")) {
                        return mi;
                    }
                    ++argIndex;
                }
                int finalArgIndex = argIndex;
                mi = mi.withArguments(ListUtils.map((List)mi.getArguments(), (i, arg) -> {
                    if (i == 0 || i < finalArgIndex) {
                        return arg;
                    }
                    return null;
                }));
                return mi;
            }
            return mi;
        }

        private static Expression replaceNewLineChars(Expression arg0) {
            if (arg0 instanceof J.Literal) {
                J.Literal fmt = (J.Literal)arg0;
                if (fmt.getValue() != null) {
                    fmt = fmt.withValue((Object)fmt.getValue().toString().replaceAll("(?<!\\\\)\n", "%n"));
                }
                if (fmt.getValueSource() != null) {
                    fmt = fmt.withValueSource(fmt.getValueSource().replaceAll("(?<!\\\\)\\\\n", "%n"));
                }
                return fmt;
            }
            return arg0;
        }
    }
}

