/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.NameCaseConvention;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.ChangeMethodName;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.VariableNameUtils;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public final class MethodNameCasing
extends ScanningRecipe<List<ChangeMethodName>> {
    private static final Pattern STANDARD_METHOD_NAME = Pattern.compile("^[a-z][a-zA-Z0-9]*$");
    private static final Pattern SNAKE_CASE = Pattern.compile("^[a-zA-Z0-9]+_\\w+$");
    @Option(displayName="Apply recipe to test source set", description="Changes only apply to main by default. `includeTestSources` will apply the recipe to `test` source files.", required=false)
    @Nullable
    private final Boolean includeTestSources;
    @Option(displayName="Rename public methods", description="Changes are not applied to public methods unless specified.", required=false)
    @Nullable
    private final Boolean renamePublicMethods;

    public String getDisplayName() {
        return "Method name casing";
    }

    public String getDescription() {
        return "Method names should comply with a naming convention.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-100");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public List<ChangeMethodName> getInitialValue(ExecutionContext ctx) {
        return new ArrayList<ChangeMethodName>();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final List<ChangeMethodName> changes) {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J preVisit(J tree, ExecutionContext ctx) {
                if (tree instanceof JavaSourceFile) {
                    JavaSourceFile cu = (JavaSourceFile)Objects.requireNonNull(tree);
                    Optional sourceSet = cu.getMarkers().findFirst(JavaSourceSet.class);
                    if (!sourceSet.isPresent()) {
                        this.stopAfterPreVisit();
                    } else if (!Boolean.TRUE.equals(MethodNameCasing.this.includeTestSources) && !"main".equals(((JavaSourceSet)sourceSet.get()).getName())) {
                        this.stopAfterPreVisit();
                    }
                }
                return (J)super.preVisit((Tree)tree, (Object)ctx);
            }

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J.ClassDeclaration enclosingClass = (J.ClassDeclaration)this.getCursor().firstEnclosing(J.ClassDeclaration.class);
                if (enclosingClass == null || enclosingClass.getKind() != J.ClassDeclaration.Kind.Type.Class) {
                    return method;
                }
                if (!(!this.containsValidModifiers(method) || method.getMethodType() == null || enclosingClass.getType() == null || method.isConstructor() || TypeUtils.isOverride((JavaType.Method)method.getMethodType()) || STANDARD_METHOD_NAME.matcher(method.getSimpleName()).matches() || method.getSimpleName().startsWith("_"))) {
                    String toName;
                    StringBuilder standardized = new StringBuilder();
                    String normalized = VariableNameUtils.normalizeName((String)method.getSimpleName());
                    char[] name = normalized.toCharArray();
                    if (SNAKE_CASE.matcher(normalized).matches()) {
                        standardized.append(NameCaseConvention.format((NameCaseConvention)NameCaseConvention.LOWER_CAMEL, (String)normalized));
                    } else {
                        for (int i = 0; i < name.length; ++i) {
                            char c = name[i];
                            if (i == 0) {
                                if (c == '$' || c == '_') continue;
                                standardized.append(Character.toLowerCase(c));
                                continue;
                            }
                            if (!Character.isLetterOrDigit(c)) {
                                while (!(i >= name.length || Character.isLetterOrDigit(name[i]) && name[i] <= 'z')) {
                                    ++i;
                                }
                                if (i >= name.length) continue;
                                standardized.append(Character.toUpperCase(name[i]));
                                continue;
                            }
                            standardized.append(c);
                        }
                    }
                    if (!(StringUtils.isBlank((String)standardized.toString()) || this.methodExists(method.getMethodType(), standardized.toString()) || StringUtils.isNumeric((String)(toName = standardized.toString())))) {
                        changes.add(new ChangeMethodName(MethodMatcher.methodPattern((J.MethodDeclaration)method), standardized.toString(), Boolean.valueOf(true), Boolean.valueOf(false)));
                    }
                }
                return super.visitMethodDeclaration(method, (Object)ctx);
            }

            private boolean containsValidModifiers(J.MethodDeclaration method) {
                return !method.hasModifier(J.Modifier.Type.Public) || Boolean.TRUE.equals(MethodNameCasing.this.renamePublicMethods);
            }

            private boolean methodExists(JavaType.Method method, String newName) {
                return TypeUtils.findDeclaredMethod((JavaType.FullyQualified)method.getDeclaringType(), (String)newName, (List)method.getParameterTypes()).orElse(null) != null;
            }
        };
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final List<ChangeMethodName> changes) {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof JavaSourceFile) {
                    JavaSourceFile cu = (JavaSourceFile)tree;
                    for (ChangeMethodName changeMethodName : changes) {
                        cu = (JavaSourceFile)changeMethodName.getVisitor().visitNonNull((Tree)cu, (Object)ctx);
                    }
                    return cu;
                }
                return (J)tree;
            }
        };
    }

    public MethodNameCasing(Boolean includeTestSources, Boolean renamePublicMethods) {
        this.includeTestSources = includeTestSources;
        this.renamePublicMethods = renamePublicMethods;
    }

    public Boolean getIncludeTestSources() {
        return this.includeTestSources;
    }

    public Boolean getRenamePublicMethods() {
        return this.renamePublicMethods;
    }

    public String toString() {
        return "MethodNameCasing(includeTestSources=" + this.getIncludeTestSources() + ", renamePublicMethods=" + this.getRenamePublicMethods() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MethodNameCasing)) {
            return false;
        }
        MethodNameCasing other = (MethodNameCasing)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$includeTestSources = this.getIncludeTestSources();
        Boolean other$includeTestSources = other.getIncludeTestSources();
        if (this$includeTestSources == null ? other$includeTestSources != null : !((Object)this$includeTestSources).equals(other$includeTestSources)) {
            return false;
        }
        Boolean this$renamePublicMethods = this.getRenamePublicMethods();
        Boolean other$renamePublicMethods = other.getRenamePublicMethods();
        return !(this$renamePublicMethods == null ? other$renamePublicMethods != null : !((Object)this$renamePublicMethods).equals(other$renamePublicMethods));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MethodNameCasing;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $includeTestSources = this.getIncludeTestSources();
        result = result * 59 + ($includeTestSources == null ? 43 : ((Object)$includeTestSources).hashCode());
        Boolean $renamePublicMethods = this.getRenamePublicMethods();
        result = result * 59 + ($renamePublicMethods == null ? 43 : ((Object)$renamePublicMethods).hashCode());
        return result;
    }
}

