/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.marker.Markers;

public class IndexOfChecksShouldUseAStartPosition
extends Recipe {
    private static final MethodMatcher STRING_INDEX_MATCHER = new MethodMatcher("java.lang.String indexOf(String)");

    public String getDisplayName() {
        return "Use `indexOf(String, int)`";
    }

    public String getDescription() {
        return "Replaces `indexOf(String)` in binary operations if the compared value is an int and not less than 1.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-2912");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(STRING_INDEX_MATCHER), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            private boolean isValueNotCompliant(J.Literal literal) {
                return !(literal.getValue() instanceof Integer) || (Integer)literal.getValue() > 0;
            }

            public J.Binary visitBinary(J.Binary binary, ExecutionContext ctx) {
                J.Binary b = super.visitBinary(binary, (Object)ctx);
                if (b.getLeft() instanceof J.MethodInvocation && STRING_INDEX_MATCHER.matches(b.getLeft()) && b.getOperator() == J.Binary.Type.GreaterThan && b.getRight() instanceof J.Literal && this.isValueNotCompliant((J.Literal)b.getRight())) {
                    J.MethodInvocation m = (J.MethodInvocation)b.getLeft();
                    Cursor cursor = new Cursor(this.getCursor(), (Object)b.getLeft());
                    b = b.withLeft((Expression)JavaTemplate.builder((String)"#{any(java.lang.String)}, #{any(int)}").build().apply(cursor, m.getCoordinates().replaceArguments(), new Object[]{m.getArguments().get(0), b.getRight()}));
                    b = b.withRight((Expression)new J.Literal(Tree.randomId(), b.getRight().getPrefix(), Markers.EMPTY, (Object)-1, "-1", null, JavaType.Primitive.Int));
                }
                return b;
            }
        });
    }
}

