/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.style.DefaultComesLastStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.marker.Markers;

public final class DefaultComesLastVisitor<P>
extends JavaIsoVisitor<P> {
    private final DefaultComesLastStyle style;

    public J.Switch visitSwitch(J.Switch switch_, P p) {
        J.Switch s = (J.Switch)this.visitAndCast((Tree)switch_, p, (x$0, x$1) -> super.visitSwitch(x$0, x$1));
        if (!this.isDefaultCaseLastOrNotPresent(switch_)) {
            List<J.Case> cases = s.getCases().getStatements().stream().map(J.Case.class::cast).collect(Collectors.toList());
            List<J.Case> casesWithDefaultLast = this.maybeReorderCases(cases, p);
            if (casesWithDefaultLast != null) {
                boolean changed = true;
                if (cases.size() == casesWithDefaultLast.size()) {
                    changed = false;
                    for (int i = 0; i < cases.size(); ++i) {
                        if (cases.get(i) == casesWithDefaultLast.get(i)) continue;
                        changed = true;
                        break;
                    }
                }
                if (changed) {
                    s = s.withCases(s.getCases().withStatements(casesWithDefaultLast.stream().map(Statement.class::cast).collect(Collectors.toList())));
                }
            }
        }
        return s;
    }

    private @Nullable List<// Could not load outer class - annotation placement on inner may be incorrect
    J.Case> maybeReorderCases(List<J.Case> cases, P p) {
        ArrayList<J.Case> fallThroughCases = new ArrayList<J.Case>();
        ArrayList<J.Case> defaultCases = new ArrayList<J.Case>();
        List<J.Case> casesWithDefaultLast = new ArrayList<J.Case>();
        boolean defaultCaseFound = false;
        for (int i = 0; i < cases.size(); ++i) {
            J.Case aCase = cases.get(i);
            if (aCase.getBody() != null) {
                return null;
            }
            fallThroughCases.add(aCase);
            if (this.isDefaultCase(aCase)) {
                defaultCaseFound = true;
            }
            if (i != cases.size() - 1 && this.isFallthroughCase(aCase.getStatements())) continue;
            if (defaultCaseFound) {
                defaultCases.addAll(fallThroughCases);
                fallThroughCases.clear();
                defaultCaseFound = false;
                continue;
            }
            casesWithDefaultLast.addAll(fallThroughCases);
            fallThroughCases.clear();
        }
        casesWithDefaultLast = this.addBreakToLastCase(casesWithDefaultLast, p);
        casesWithDefaultLast.addAll(this.maybeReorderFallthroughCases(defaultCases, p));
        return ListUtils.mapLast(casesWithDefaultLast, this::removeBreak);
    }

    private List<J.Case> maybeReorderFallthroughCases(List<J.Case> cases, P p) {
        ArrayList<J.Case> preDefaultCases = new ArrayList<J.Case>();
        ArrayList<J.Case> postDefaultCases = new ArrayList<J.Case>();
        J.Case defaultCase = null;
        for (int i = 0; i < cases.size(); ++i) {
            J.Case aCase = cases.get(i);
            if (this.isDefaultCase(aCase)) {
                if (!aCase.getStatements().isEmpty()) {
                    return cases;
                }
                defaultCase = aCase;
                continue;
            }
            if (defaultCase != null) {
                if (!aCase.getStatements().isEmpty() && i != cases.size() - 1) {
                    return cases;
                }
                postDefaultCases.add(aCase);
                continue;
            }
            preDefaultCases.add(aCase);
        }
        ArrayList<J.Case> fixedCases = new ArrayList<J.Case>(preDefaultCases);
        if (!postDefaultCases.isEmpty()) {
            List statements = ((J.Case)postDefaultCases.get(postDefaultCases.size() - 1)).getStatements();
            defaultCase = defaultCase.withStatements(statements);
            fixedCases.addAll(ListUtils.mapLast(postDefaultCases, e -> e.withStatements(Collections.emptyList())));
        }
        assert (defaultCase != null);
        fixedCases.add(defaultCase);
        return fixedCases;
    }

    private List<J.Case> addBreakToLastCase(List<J.Case> cases, P p) {
        return ListUtils.mapLast(cases, e -> {
            if (this.isFallthroughCase(e.getStatements())) {
                return this.addBreak((J.Case)e, p);
            }
            return e;
        });
    }

    private boolean isFallthroughCase(List<Statement> statements) {
        if (statements.isEmpty()) {
            return true;
        }
        Statement lastStatement = statements.get(statements.size() - 1);
        if (lastStatement instanceof J.Block) {
            return this.isFallthroughCase(((J.Block)lastStatement).getStatements());
        }
        return !(lastStatement instanceof J.Break) && !(lastStatement instanceof J.Continue) && !(lastStatement instanceof J.Return) && !(lastStatement instanceof J.Throw) && !(lastStatement instanceof J.Yield);
    }

    private J.Case addBreak(J.Case e, P p) {
        List statements = e.getStatements();
        J.Switch switchStatement = (J.Switch)this.getCursor().getValue();
        int switchIndent = switchStatement.getPrefix().getIndent().length();
        int caseIndent = ((Statement)switchStatement.getCases().getStatements().get(0)).getPrefix().getIndent().length();
        int breakIndent = caseIndent + (caseIndent - switchIndent);
        Space prefix = breakIndent > 0 ? Space.build((String)String.format("\n%" + breakIndent + "s", ""), Collections.emptyList()) : Space.EMPTY;
        J.Break breakStatement = new J.Break(Tree.randomId(), prefix, Markers.EMPTY, null);
        if (!statements.isEmpty() && statements.get(statements.size() - 1) instanceof J.Block) {
            statements = ListUtils.mapLast((List)statements, s -> {
                J.Block block = (J.Block)s;
                List blockStatements = block.getStatements();
                blockStatements.add(breakStatement);
                return block.withStatements(blockStatements);
            });
        } else {
            statements.add(breakStatement);
        }
        return e.withStatements(statements);
    }

    private J.Case removeBreak(J.Case aCase) {
        if (!aCase.getStatements().isEmpty() && aCase.getStatements().get(aCase.getStatements().size() - 1) instanceof J.Break && ((J.Break)aCase.getStatements().get(aCase.getStatements().size() - 1)).getLabel() == null) {
            aCase = aCase.withStatements(aCase.getStatements().subList(0, aCase.getStatements().size() - 1));
        }
        return aCase;
    }

    private boolean isDefaultCaseLastOrNotPresent(J.Switch switch_) {
        J.Case defaultCase = null;
        J.Case prior = null;
        for (Statement aCaseStmt : switch_.getCases().getStatements()) {
            if (!(aCaseStmt instanceof J.Case)) continue;
            J.Case aCase = (J.Case)aCaseStmt;
            if (defaultCase != null) {
                return false;
            }
            if (this.isDefaultCase(aCase)) {
                defaultCase = aCase;
            }
            if (defaultCase != null && prior != null && Boolean.TRUE.equals(this.style.getSkipIfLastAndSharedWithCase()) && prior.getStatements().isEmpty()) {
                return true;
            }
            prior = aCase;
        }
        return true;
    }

    private boolean isDefaultCase(J.Case case_) {
        J elem = (J)case_.getCaseLabels().get(0);
        return elem instanceof J.Identifier && ((J.Identifier)elem).getSimpleName().equals("default");
    }

    @Generated
    public DefaultComesLastVisitor(DefaultComesLastStyle style) {
        this.style = style;
    }

    @Generated
    public DefaultComesLastStyle getStyle() {
        return this.style;
    }

    @Generated
    public String toString() {
        return "DefaultComesLastVisitor(style=" + this.getStyle() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultComesLastVisitor)) {
            return false;
        }
        DefaultComesLastVisitor other = (DefaultComesLastVisitor)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        DefaultComesLastStyle this$style = this.getStyle();
        DefaultComesLastStyle other$style = other.getStyle();
        return !(this$style == null ? other$style != null : !this$style.equals(other$style));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DefaultComesLastVisitor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DefaultComesLastStyle $style = this.getStyle();
        result = result * 59 + ($style == null ? 43 : $style.hashCode());
        return result;
    }
}

