/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;

public class WhileInsteadOfFor
extends Recipe {
    public String getDisplayName() {
        return "Prefer `while` over `for` loops";
    }

    public String getDescription() {
        return "When only the condition expression is defined in a for loop, and the initialization and increment expressions are missing, a while loop should be used instead to increase readability.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-S1264");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){
            final JavaTemplate whileLoop = JavaTemplate.builder((String)"while(#{any(boolean)}) {}").build();

            public J visitForLoop(J.ForLoop forLoop, ExecutionContext ctx) {
                if (forLoop.getControl().getInit().get(0) instanceof J.Empty && forLoop.getControl().getUpdate().get(0) instanceof J.Empty && !(forLoop.getControl().getCondition() instanceof J.Empty)) {
                    J.WhileLoop w = (J.WhileLoop)this.whileLoop.apply(this.getCursor(), forLoop.getCoordinates().replace(), new Object[]{forLoop.getControl().getCondition()});
                    return w.withBody(forLoop.getBody());
                }
                return super.visitForLoop(forLoop, (Object)ctx);
            }
        };
    }
}

