/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.style.Checkstyle;
import org.openrewrite.java.style.HideUtilityClassConstructorStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.staticanalysis.HideUtilityClassConstructorVisitor;

@Incubating(since="7.0.0")
public class HideUtilityClassConstructor
extends Recipe {
    public String getDisplayName() {
        return "Hide utility class constructor";
    }

    public String getDescription() {
        return "Ensures utility classes (classes containing only static methods or fields in their API) do not have a public constructor.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-S1118");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new HideUtilityClassConstructorFromCompilationUnitStyle();
    }

    private static class HideUtilityClassConstructorFromCompilationUnitStyle
    extends JavaIsoVisitor<ExecutionContext> {
        private HideUtilityClassConstructorFromCompilationUnitStyle() {
        }

        public J visit(@Nullable Tree tree, ExecutionContext ctx) {
            if (tree instanceof JavaSourceFile) {
                JavaSourceFile cu = (JavaSourceFile)Objects.requireNonNull(tree);
                HideUtilityClassConstructorStyle style = (HideUtilityClassConstructorStyle)cu.getStyle(HideUtilityClassConstructorStyle.class);
                if (style == null) {
                    style = Checkstyle.hideUtilityClassConstructorStyle();
                }
                return (J)new HideUtilityClassConstructorVisitor(style).visit((Tree)cu, ctx);
            }
            return (J)tree;
        }
    }
}

