/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.List;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.format.ShiftFormat;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;

public class SimplifyElseBranch
extends Recipe {
    public String getDisplayName() {
        return "Simplify `else` branch if it only has a single `if`";
    }

    public String getDescription() {
        return "Simplify `else` branch if it only has a single `if`.";
    }

    public JavaIsoVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.If.Else visitElse(J.If.Else else_, ExecutionContext ctx) {
                Statement firstStatement;
                J.Block block;
                J.If.Else elseStatement = super.visitElse(else_, (Object)ctx);
                Statement body = elseStatement.getBody();
                if (body instanceof J.Block && (block = (J.Block)body).getStatements().size() == 1 && (firstStatement = (Statement)block.getStatements().get(0)) instanceof J.If) {
                    J.If ifStatement = (J.If)firstStatement.withPrefix(Space.SINGLE_SPACE).withComments(ListUtils.concatAll((List)block.getComments(), (List)firstStatement.getComments()));
                    return elseStatement.withBody((Statement)ShiftFormat.indent((J)ifStatement, (Cursor)this.getCursor(), (int)-1));
                }
                return elseStatement;
            }
        };
    }
}

