/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.SemanticallyEqual;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public final class RemoveRedundantNullCheckBeforeLiteralEquals
extends Recipe {
    private static final MethodMatcher EQUALS_MATCHER = new MethodMatcher("java.lang.String equals(java.lang.Object)");

    public String getDisplayName() {
        return "Remove redundant null checks before literal equals";
    }

    public String getDescription() {
        return "Removes redundant null checks before `equals()` comparisons when the receiver is a literal string, since literals can never be null and `equals()` returns false for null arguments.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){

            public J visitBinary(J.Binary binary, ExecutionContext ctx) {
                J.MethodInvocation equalsCall;
                J.Binary nullCheck;
                J.Binary bi = (J.Binary)super.visitBinary(binary, (Object)ctx);
                if (bi.getOperator() != J.Binary.Type.And) {
                    return bi;
                }
                Expression left = bi.getLeft();
                Expression right = bi.getRight();
                if (left instanceof J.Binary && right instanceof J.MethodInvocation && this.isRedundantNullCheck(nullCheck = (J.Binary)left, equalsCall = (J.MethodInvocation)right)) {
                    return equalsCall.withPrefix(bi.getPrefix());
                }
                if (left instanceof J.Binary && ((J.Binary)left).getOperator() == J.Binary.Type.And && right instanceof J.MethodInvocation) {
                    J.Binary leftBinary = (J.Binary)left;
                    equalsCall = (J.MethodInvocation)right;
                    Expression rightmostOfLeft = leftBinary.getRight();
                    if (rightmostOfLeft instanceof J.Binary && this.isRedundantNullCheck((J.Binary)rightmostOfLeft, equalsCall)) {
                        return bi.withLeft(leftBinary.getLeft()).withRight((Expression)equalsCall);
                    }
                }
                return bi;
            }

            private boolean isRedundantNullCheck(J.Binary nullCheck, J.MethodInvocation equalsCall) {
                if (nullCheck.getOperator() != J.Binary.Type.NotEqual) {
                    return false;
                }
                if (!EQUALS_MATCHER.matches((MethodCall)equalsCall)) {
                    return false;
                }
                Expression receiver = equalsCall.getSelect();
                if (!(receiver instanceof J.Literal) || !(((J.Literal)receiver).getValue() instanceof String)) {
                    return false;
                }
                if (equalsCall.getArguments().size() != 1) {
                    return false;
                }
                Expression equalsArg = (Expression)equalsCall.getArguments().get(0);
                if (J.Literal.isLiteralValue((Expression)nullCheck.getLeft(), null)) {
                    return SemanticallyEqual.areEqual((J)nullCheck.getRight(), (J)equalsArg);
                }
                if (J.Literal.isLiteralValue((Expression)nullCheck.getRight(), null)) {
                    return SemanticallyEqual.areEqual((J)nullCheck.getLeft(), (J)equalsArg);
                }
                return false;
            }
        };
    }

    @Generated
    public RemoveRedundantNullCheckBeforeLiteralEquals() {
    }

    @Generated
    public String toString() {
        return "RemoveRedundantNullCheckBeforeLiteralEquals()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveRedundantNullCheckBeforeLiteralEquals)) {
            return false;
        }
        RemoveRedundantNullCheckBeforeLiteralEquals other = (RemoveRedundantNullCheckBeforeLiteralEquals)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RemoveRedundantNullCheckBeforeLiteralEquals;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

