/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.java.tree.TypedTree;
import org.openrewrite.marker.Markers;
import org.openrewrite.staticanalysis.java.JavaFileChecker;

public class UseDiamondOperator
extends Recipe {
    public String getDisplayName() {
        return "Use the diamond operator";
    }

    public String getDescription() {
        return "The diamond operator (`<>`) should be used. Java 7 introduced the diamond operator (<>) to reduce the verbosity of generics code. For instance, instead of having to declare a `List`'s type in both its declaration and its constructor, you can now simplify the constructor declaration with `<>`, and the compiler will infer the type.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-S2293");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new JavaFileChecker(), (TreeVisitor)new UseDiamondOperatorVisitor());
    }

    private static class UseDiamondOperatorVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private boolean java9;

        private UseDiamondOperatorVisitor() {
        }

        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
            this.java9 = new UsesJavaVersion(9).visit((Tree)cu, (Object)0) != cu;
            return super.visitCompilationUnit(cu, (Object)ctx);
        }

        public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
            J.VariableDeclarations varDecls = super.visitVariableDeclarations(multiVariable, (Object)ctx);
            TypeTree varDeclsTypeExpression = varDecls.getTypeExpression();
            if (varDeclsTypeExpression != null && varDecls.getVariables().size() == 1 && ((J.VariableDeclarations.NamedVariable)varDecls.getVariables().get(0)).getInitializer() != null && varDecls.getTypeExpression() instanceof J.ParameterizedType) {
                varDecls = varDecls.withVariables(ListUtils.map((List)varDecls.getVariables(), arg_0 -> this.lambda$visitVariableDeclarations$0((TypedTree)varDeclsTypeExpression, arg_0)));
            }
            return varDecls;
        }

        public J.Assignment visitAssignment(J.Assignment assignment, ExecutionContext ctx) {
            J.Assignment asgn = super.visitAssignment(assignment, (Object)ctx);
            if (asgn.getAssignment() instanceof J.NewClass) {
                JavaType.Parameterized assignmentType = TypeUtils.asParameterized((JavaType)asgn.getType());
                J.NewClass nc = (J.NewClass)asgn.getAssignment();
                if (assignmentType != null && nc.getClazz() instanceof J.ParameterizedType) {
                    asgn = asgn.withAssignment((Expression)this.maybeRemoveParams(assignmentType.getTypeParameters(), nc));
                }
            }
            return asgn;
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            if (this.isAParameter()) {
                return method;
            }
            J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
            JavaType.Method methodType = mi.getMethodType();
            if (methodType != null && !mi.getArguments().isEmpty() && methodType.getParameterTypes().size() <= mi.getArguments().size()) {
                Optional declaredMethodType = TypeUtils.findDeclaredMethod((JavaType.FullyQualified)methodType.getDeclaringType(), (String)methodType.getName(), (List)methodType.getParameterTypes());
                if (!declaredMethodType.isPresent()) {
                    return method;
                }
                mi = mi.withArguments(ListUtils.map((List)mi.getArguments(), (i, arg) -> {
                    if (arg instanceof J.NewClass) {
                        JavaType.Parameterized paramType;
                        boolean isVarArg;
                        boolean isGenericType = false;
                        boolean bl = isVarArg = methodType.getParameterTypes().size() == 1 && methodType.getParameterTypes().get(0) instanceof JavaType.Array;
                        if (isVarArg) {
                            isGenericType = this.isGenericType(((JavaType.Array)methodType.getParameterTypes().get(0)).getElemType());
                        } else if (i < methodType.getParameterTypes().size()) {
                            JavaType parameterType = (JavaType)methodType.getParameterTypes().get((int)i);
                            isGenericType = this.isGenericType(parameterType);
                        }
                        if (isGenericType) {
                            return arg;
                        }
                        J.NewClass nc = (J.NewClass)arg;
                        if ((this.java9 || nc.getBody() == null) && !methodType.getParameterTypes().isEmpty() && (paramType = TypeUtils.asParameterized((JavaType)this.getMethodParamType(methodType, (int)i))) != null && nc.getClazz() instanceof J.ParameterizedType) {
                            return this.maybeRemoveParams(paramType.getTypeParameters(), nc);
                        }
                    }
                    return arg;
                }));
            }
            return mi;
        }

        private boolean isGenericType(@Nullable JavaType type) {
            if (type == null) {
                return false;
            }
            boolean isGeneric = false;
            JavaType.Parameterized parameterized = TypeUtils.asParameterized((JavaType)type);
            if (parameterized != null) {
                List types = parameterized.getTypeParameters();
                for (JavaType tp : types) {
                    if (!(tp instanceof JavaType.GenericTypeVariable)) continue;
                    isGeneric = true;
                    break;
                }
            }
            return isGeneric;
        }

        private JavaType getMethodParamType(JavaType.Method methodType, int paramIndex) {
            if (methodType.hasFlags(new Flag[]{Flag.Varargs}) && paramIndex >= methodType.getParameterTypes().size() - 1) {
                return ((JavaType.Array)methodType.getParameterTypes().get(methodType.getParameterTypes().size() - 1)).getElemType();
            }
            return (JavaType)methodType.getParameterTypes().get(paramIndex);
        }

        public J.Return visitReturn(J.Return _return, ExecutionContext ctx) {
            J.MethodDeclaration md;
            J parentBlock;
            J.NewClass nc;
            J.Return return_ = super.visitReturn(_return, (Object)ctx);
            J.NewClass newClass = nc = return_.getExpression() instanceof J.NewClass ? (J.NewClass)return_.getExpression() : null;
            if (nc != null && (this.java9 || nc.getBody() == null) && nc.getClazz() instanceof J.ParameterizedType && (parentBlock = (J)this.getCursor().dropParentUntil(v -> v instanceof J.MethodDeclaration || v instanceof J.Lambda).getValue()) instanceof J.MethodDeclaration && (md = (J.MethodDeclaration)parentBlock).getReturnTypeExpression() instanceof J.ParameterizedType) {
                return_ = return_.withExpression((Expression)this.maybeRemoveParams(this.parameterizedTypes((J.ParameterizedType)md.getReturnTypeExpression()), nc));
            }
            return return_;
        }

        private @Nullable List<JavaType> parameterizedTypes(J.ParameterizedType parameterizedType) {
            if (parameterizedType.getTypeParameters() == null) {
                return null;
            }
            ArrayList<JavaType> types = new ArrayList<JavaType>(parameterizedType.getTypeParameters().size());
            for (Expression typeParameter : parameterizedType.getTypeParameters()) {
                types.add(typeParameter.getType());
            }
            return types;
        }

        private J.NewClass maybeRemoveParams(@Nullable List<JavaType> paramTypes, J.NewClass newClass) {
            J.ParameterizedType newClassType;
            if (paramTypes != null && (this.java9 || newClass.getBody() == null) && newClass.getClazz() instanceof J.ParameterizedType && (newClassType = (J.ParameterizedType)newClass.getClazz()).getTypeParameters() != null) {
                if (paramTypes.size() != newClassType.getTypeParameters().size() || UseDiamondOperatorVisitor.hasAnnotations((J)newClassType)) {
                    return newClass;
                }
                for (int i = 0; i < paramTypes.size(); ++i) {
                    if (TypeUtils.isAssignableTo((JavaType)paramTypes.get(i), (JavaType)((Expression)newClassType.getTypeParameters().get(i)).getType())) continue;
                    return newClass;
                }
                newClassType.getTypeParameters().stream().map(e -> TypeUtils.asFullyQualified((JavaType)e.getType())).forEach(arg_0 -> ((UseDiamondOperatorVisitor)this).maybeRemoveImport(arg_0));
                newClass = newClass.withClazz((TypeTree)newClassType.withTypeParameters(Collections.singletonList(new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY))));
            }
            return newClass;
        }

        private static boolean hasAnnotations(J type) {
            if (type instanceof J.ParameterizedType) {
                J.ParameterizedType parameterizedType = (J.ParameterizedType)type;
                if (UseDiamondOperatorVisitor.hasAnnotations((J)parameterizedType.getClazz())) {
                    return true;
                }
                if (parameterizedType.getTypeParameters() != null) {
                    for (Expression typeParameter : parameterizedType.getTypeParameters()) {
                        if (!UseDiamondOperatorVisitor.hasAnnotations((J)typeParameter)) continue;
                        return true;
                    }
                }
            } else {
                return type instanceof J.AnnotatedType;
            }
            return false;
        }

        private boolean isAParameter() {
            return this.getCursor().dropParentUntil(p -> p instanceof J.MethodInvocation || p instanceof J.ClassDeclaration || p instanceof J.CompilationUnit || p instanceof J.Block || p == "root").getValue() instanceof J.MethodInvocation;
        }

        private /* synthetic */ J.VariableDeclarations.NamedVariable lambda$visitVariableDeclarations$0(TypedTree varDeclsTypeExpression, J.VariableDeclarations.NamedVariable nv) {
            if (nv.getInitializer() instanceof J.NewClass) {
                nv = nv.withInitializer((Expression)this.maybeRemoveParams(this.parameterizedTypes((J.ParameterizedType)varDeclsTypeExpression), (J.NewClass)nv.getInitializer()));
            }
            return nv;
        }
    }
}

