/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.struts;

import java.util.List;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.struts.search.FindStrutsXml;
import org.openrewrite.xml.XmlIsoVisitor;
import org.openrewrite.xml.tree.Xml;

public final class MigrateStrutsDtd
extends Recipe {
    @Option(displayName="Struts version", description="The Struts version to migrate to.", example="6.0", valid={"2.3", "2.5", "6.0"})
    private final String strutsVersion;

    public String getDisplayName() {
        return "Migrate DTD to a specific Struts version";
    }

    public String getDescription() {
        return "Update Struts DTD to reflect the specified version.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new FindStrutsXml(), (TreeVisitor)new XmlIsoVisitor<ExecutionContext>(){

            public Xml.DocTypeDecl visitDocTypeDecl(Xml.DocTypeDecl docTypeDecl, ExecutionContext ctx) {
                return docTypeDecl.withInternalSubset(ListUtils.map((List)docTypeDecl.getInternalSubset(), (n, ref) -> {
                    if (n == 0 && !ref.getName().equals("\"-//Apache Software Foundation//DTD Struts Configuration " + MigrateStrutsDtd.this.strutsVersion + "//EN\"")) {
                        return ref.withName("\"-//Apache Software Foundation//DTD Struts Configuration " + MigrateStrutsDtd.this.strutsVersion + "//EN\"");
                    }
                    if (n == 1 && !ref.getName().equals("\"https://struts.apache.org/dtds/struts-" + MigrateStrutsDtd.this.strutsVersion + ".dtd\"")) {
                        return ref.withName("\"https://struts.apache.org/dtds/struts-" + MigrateStrutsDtd.this.strutsVersion + ".dtd\"");
                    }
                    return ref;
                }));
            }
        });
    }

    @Generated
    public MigrateStrutsDtd(String strutsVersion) {
        this.strutsVersion = strutsVersion;
    }

    @Generated
    public String getStrutsVersion() {
        return this.strutsVersion;
    }

    @Generated
    public String toString() {
        return "MigrateStrutsDtd(strutsVersion=" + this.getStrutsVersion() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MigrateStrutsDtd)) {
            return false;
        }
        MigrateStrutsDtd other = (MigrateStrutsDtd)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$strutsVersion = this.getStrutsVersion();
        String other$strutsVersion = other.getStrutsVersion();
        return !(this$strutsVersion == null ? other$strutsVersion != null : !this$strutsVersion.equals(other$strutsVersion));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MigrateStrutsDtd;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $strutsVersion = this.getStrutsVersion();
        result = result * 59 + ($strutsVersion == null ? 43 : $strutsVersion.hashCode());
        return result;
    }
}

