/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.struts.search;

import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.struts.internal.TagUtils;
import org.openrewrite.java.struts.table.StrutsActions;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.XmlIsoVisitor;
import org.openrewrite.xml.search.FindTags;
import org.openrewrite.xml.tree.Xml;

public class FindStrutsActions
extends Recipe {
    private final transient StrutsActions actions = new StrutsActions(this);

    public String getDisplayName() {
        return "Find Struts actions";
    }

    public String getDescription() {
        return "Find actions and their associated definitions.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final XPathMatcher actionMatcher = new XPathMatcher("//action");
        return Preconditions.check((Recipe)new FindTags("/struts"), (TreeVisitor)new XmlIsoVisitor<ExecutionContext>(){

            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                if (actionMatcher.matches(this.getCursor())) {
                    String pkg = this.getCursor().getPathAsStream(Xml.Tag.class::isInstance).map(Xml.Tag.class::cast).filter(t -> t.getName().equals("package")).map(t -> TagUtils.getAttribute(t, "name", "")).collect(Collectors.joining("."));
                    FindStrutsActions.this.actions.insertRow(ctx, new StrutsActions.Row(((SourceFile)this.getCursor().firstEnclosingOrThrow(SourceFile.class)).getSourcePath().toString(), pkg, TagUtils.getAttribute(tag, "name", "unknown"), TagUtils.getAttribute(tag, "class", "unknown"), TagUtils.getAttribute(tag, "method", "unknown")));
                    return (Xml.Tag)SearchResult.found((Tree)tag);
                }
                return super.visitTag(tag, (Object)ctx);
            }
        });
    }
}

