/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.AutoConfigure;
import org.openrewrite.Formatting;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Tree;
import org.openrewrite.java.AddAnnotation;
import org.openrewrite.java.AutoFormat;
import org.openrewrite.java.JavaRefactorVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

@AutoConfigure
public class CategoryToTag
extends JavaRefactorVisitor {
    private static final String categoryAnnotation = "org.junit.experimental.categories.Category";
    private static final JavaType.Class tagType = JavaType.Class.build((String)"org.junit.jupiter.api.Tag");

    public J visitClassDecl(J.ClassDecl classDecl) {
        J.ClassDecl cd = (J.ClassDecl)this.refactor((Tree)classDecl, x$0 -> super.visitClassDecl(x$0));
        if (!cd.findAnnotations("@org.junit.experimental.categories.Category").isEmpty()) {
            this.andThen((RefactorVisitor)new Scoped((J)cd));
        }
        return cd;
    }

    public J visitMethod(J.MethodDecl method) {
        J.MethodDecl cd = (J.MethodDecl)this.refactor((Tree)method, x$0 -> super.visitMethod(x$0));
        if (!cd.findAnnotations("@org.junit.experimental.categories.Category").isEmpty()) {
            this.andThen((RefactorVisitor)new Scoped((J)cd));
        }
        return cd;
    }

    public static class Scoped
    extends JavaRefactorVisitor {
        final J statement;

        public Scoped(J statement) {
            this.statement = statement;
        }

        public J visitClassDecl(J.ClassDecl classDecl) {
            J.ClassDecl c = (J.ClassDecl)this.refactor((Tree)classDecl, x$0 -> super.visitClassDecl(x$0));
            if (this.statement.isScope((Tree)classDecl) && !classDecl.findAnnotations("@org.junit.experimental.categories.Category").isEmpty()) {
                classDecl.findAnnotations("@org.junit.experimental.categories.Category").stream().forEach(annot -> {
                    Expression categoryArgs = (Expression)annot.getArgs().getArgs().iterator().next();
                    Stream<Expression> categories = categoryArgs instanceof J.NewArray ? ((J.NewArray)categoryArgs).getInitializer().getElements().stream() : Stream.of(categoryArgs);
                    categories.forEach(arg -> this.andThen((RefactorVisitor)new AddAnnotation.Scoped((Tree)classDecl, "org.junit.jupiter.api.Tag", new Expression[]{(Expression)arg.withPrefix("")})));
                });
                c = c.withAnnotations(c.getAnnotations().stream().filter(annot -> !TypeUtils.isOfClassType((JavaType)annot.getAnnotationType().getType(), (String)CategoryToTag.categoryAnnotation)).collect(Collectors.toList()));
            }
            this.maybeRemoveImport(CategoryToTag.categoryAnnotation);
            this.maybeAddImport((JavaType.FullyQualified)tagType);
            return c;
        }

        public J visitMethod(J.MethodDecl methodDecl) {
            J.MethodDecl m = (J.MethodDecl)this.refactor((Tree)methodDecl, x$0 -> super.visitMethod(x$0));
            if (this.statement.isScope((Tree)methodDecl) && !methodDecl.findAnnotations("@org.junit.experimental.categories.Category").isEmpty()) {
                m = m.withAnnotations(m.getAnnotations().stream().flatMap(annot -> {
                    if (TypeUtils.isOfClassType((JavaType)annot.getAnnotationType().getType(), (String)CategoryToTag.categoryAnnotation)) {
                        if (annot.getArgs() == null) {
                            return Stream.empty();
                        }
                        AtomicInteger index = new AtomicInteger(0);
                        Expression value = (Expression)annot.getArgs().getArgs().iterator().next();
                        Stream<Expression> categories = value instanceof J.NewArray ? ((J.NewArray)value).getInitializer().getElements().stream() : Stream.of(value);
                        return categories.map(arg -> {
                            J.Annotation annotation = J.Annotation.buildAnnotation((Formatting)annot.getFormatting(), (JavaType.Class)tagType, Collections.singletonList((Expression)arg.withPrefix("")));
                            if (index.getAndIncrement() != 0) {
                                annotation = (J.Annotation)annotation.withPrefix("\n");
                                this.andThen((RefactorVisitor)new AutoFormat(new J[]{annotation}));
                            }
                            return annotation;
                        });
                    }
                    return Stream.of(annot);
                }).collect(Collectors.toList()));
            }
            this.maybeRemoveImport(CategoryToTag.categoryAnnotation);
            this.maybeAddImport((JavaType.FullyQualified)tagType);
            return m;
        }
    }
}

