/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.AutoConfigure;
import org.openrewrite.CompositeRefactorVisitor;
import org.openrewrite.Formatting;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaIsoRefactorVisitor;
import org.openrewrite.java.search.SemanticallyEqual;
import org.openrewrite.java.testing.junit5.FrameworkTypes;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.maven.AddDependency;
import org.openrewrite.maven.MavenRefactorVisitor;
import org.openrewrite.maven.tree.Maven;

@AutoConfigure
public class MockitoRunnerToMockitoExtension
extends CompositeRefactorVisitor {
    public MockitoRunnerToMockitoExtension() {
        AnnotationUpdate annotationUpdate = new AnnotationUpdate();
        DependencyUpdate dependencyUpdate = new DependencyUpdate(annotationUpdate);
        this.addVisitor((RefactorVisitor)annotationUpdate);
        this.addVisitor((RefactorVisitor)dependencyUpdate);
    }

    private static class DependencyUpdate
    extends MavenRefactorVisitor {
        final AnnotationUpdate annotationUpdate;

        private DependencyUpdate(AnnotationUpdate annotationUpdate) {
            this.annotationUpdate = annotationUpdate;
        }

        public Maven visitMaven(Maven maven) {
            if (this.annotationUpdate.getPerformedRefactor()) {
                AddDependency addMockitoJunitJupiterDependency = new AddDependency();
                addMockitoJunitJupiterDependency.setGroupId("org.mockito");
                addMockitoJunitJupiterDependency.setArtifactId("mockito-junit-jupiter");
                addMockitoJunitJupiterDependency.setVersion("3.x");
                addMockitoJunitJupiterDependency.setScope("test");
                if (!this.andThen().contains(addMockitoJunitJupiterDependency)) {
                    this.andThen((RefactorVisitor)addMockitoJunitJupiterDependency);
                }
            }
            return super.visitMaven(maven);
        }
    }

    private static class AnnotationUpdate
    extends JavaIsoRefactorVisitor {
        private static final List<JavaType.Class> runWithMockitoAnnotationTypes = Stream.of("org.mockito.runners.MockitoJUnitRunner", "org.mockito.junit.MockitoJUnitRunner", "org.mockito.runners.MockitoJUnit44Runner", "org.mockito.junit.MockitoJUnit44Runner").map(JavaType.Class::build).collect(Collectors.toList());
        private static final List<J.Annotation> runWithMockitoAnnotations = runWithMockitoAnnotationTypes.stream().map(type -> new J.Annotation(Tree.randomId(), (NameTree)FrameworkTypes.runWithIdent, new J.Annotation.Arguments(Tree.randomId(), Collections.singletonList(new J.FieldAccess(Tree.randomId(), (Expression)J.Ident.build((UUID)Tree.randomId(), (String)type.getClassName(), (JavaType)type, (Formatting)Formatting.EMPTY), J.Ident.build((UUID)Tree.randomId(), (String)"class", null, (Formatting)Formatting.EMPTY), (JavaType)JavaType.Class.build((String)"java.lang.Class"), Formatting.EMPTY)), Formatting.EMPTY), Formatting.EMPTY)).collect(Collectors.toList());
        private static final JavaType.Class mockitoExtensionType = JavaType.Class.build((String)"org.mockito.junit.jupiter.MockitoExtension");
        private static final J.Annotation extendWithMockitoExtensionAnnotation = new J.Annotation(Tree.randomId(), (NameTree)FrameworkTypes.extendWithIdent, new J.Annotation.Arguments(Tree.randomId(), Collections.singletonList(new J.FieldAccess(Tree.randomId(), (Expression)J.Ident.build((UUID)Tree.randomId(), (String)"MockitoExtension", (JavaType)mockitoExtensionType, (Formatting)Formatting.EMPTY), J.Ident.build((UUID)Tree.randomId(), (String)"class", null, (Formatting)Formatting.EMPTY), (JavaType)JavaType.Class.build((String)"java.lang.Class"), Formatting.EMPTY)), Formatting.EMPTY), Formatting.EMPTY);
        private boolean performedRefactor = false;

        public boolean getPerformedRefactor() {
            return this.performedRefactor;
        }

        public void nextCycle() {
            this.performedRefactor = false;
        }

        public AnnotationUpdate() {
            this.setCursoringOn();
        }

        public J.ClassDecl visitClassDecl(J.ClassDecl cd) {
            boolean shouldReplaceAnnotation = cd.getAnnotations().stream().filter(this::shouldReplaceAnnotation).findAny().isPresent();
            if (shouldReplaceAnnotation) {
                this.performedRefactor = true;
                List annotations = cd.getAnnotations().stream().map(this::mockitoRunnerToMockitoExtension).collect(Collectors.toList());
                return cd.withAnnotations(annotations);
            }
            return cd;
        }

        private J.Annotation mockitoRunnerToMockitoExtension(J.Annotation maybeMockitoAnnotation) {
            if (!this.shouldReplaceAnnotation(maybeMockitoAnnotation)) {
                return maybeMockitoAnnotation;
            }
            Formatting originalFormatting = maybeMockitoAnnotation.getFormatting();
            J.Annotation extendWithSpringExtension = extendWithMockitoExtensionAnnotation.withFormatting(originalFormatting);
            this.maybeAddImport((JavaType.FullyQualified)FrameworkTypes.extendWithType);
            this.maybeAddImport((JavaType.FullyQualified)mockitoExtensionType);
            runWithMockitoAnnotationTypes.stream().forEach(arg_0 -> ((AnnotationUpdate)this).maybeRemoveImport(arg_0));
            this.maybeRemoveImport((JavaType.FullyQualified)FrameworkTypes.runWithType);
            return extendWithSpringExtension;
        }

        private boolean shouldReplaceAnnotation(J.Annotation maybeMockitoRunner) {
            return runWithMockitoAnnotations.stream().filter(mockitoRunnerAnnotation -> (Boolean)new SemanticallyEqual((Tree)mockitoRunnerAnnotation).visit((Tree)maybeMockitoRunner)).findAny().isPresent();
        }
    }
}

