/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.AutoConfigure;
import org.openrewrite.Formatting;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Tree;
import org.openrewrite.java.AutoFormat;
import org.openrewrite.java.JavaIsoRefactorVisitor;
import org.openrewrite.java.JavaRefactorVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;

@AutoConfigure
public class TemporaryFolderToTempDir
extends JavaIsoRefactorVisitor {
    private static final String RuleFqn = "org.junit.Rule";
    private static final String TemporaryFolderFqn = "org.junit.rules.TemporaryFolder";
    private static final JavaType.Class TempDirType = JavaType.Class.build((String)"org.junit.jupiter.api.io.TempDir");
    private static final J.Ident TempDirIdent = J.Ident.build((UUID)Tree.randomId(), (String)"TempDir", (JavaType)TempDirType, (Formatting)Formatting.EMPTY);
    private static final JavaType.Class FileType = JavaType.Class.build((String)"java.io.File");
    private static final J.Ident FileIdent = J.Ident.build((UUID)Tree.randomId(), (String)"File", (JavaType)FileType, (Formatting)Formatting.EMPTY);
    private static final JavaType.Class PathType = JavaType.Class.build((String)"java.nio.file.Path");
    private static final JavaType.Class FilesType = JavaType.Class.build((String)"java.nio.file.Files");
    private static final String IOExceptionFqn = "java.io.IOException";
    private static final JavaType.Class IOExceptionType = JavaType.Class.build((String)"java.io.IOException");
    private static final JavaType.Class StringType = JavaType.Class.build((String)"java.lang.String");

    public J.ClassDecl visitClassDecl(J.ClassDecl classDecl) {
        J.ClassDecl cd = super.visitClassDecl(classDecl);
        if (cd.getFields().stream().anyMatch(it -> TypeUtils.hasElementType((JavaType)it.getTypeAsClass(), (String)TemporaryFolderFqn))) {
            List newStatements = cd.getBody().getStatements().stream().map(this::convertTempFolderField).collect(Collectors.toList());
            cd = cd.withBody(cd.getBody().withStatements(newStatements));
        }
        return cd;
    }

    private J convertTempFolderField(J statement) {
        if (!(statement instanceof J.VariableDecls)) {
            return statement;
        }
        J.VariableDecls field = (J.VariableDecls)statement;
        if (field.getTypeAsClass() == null || !field.getTypeAsClass().getFullyQualifiedName().equals(TemporaryFolderFqn)) {
            return field;
        }
        List newAnnotations = Stream.concat(Stream.of(new J.Annotation(Tree.randomId(), (NameTree)TempDirIdent, null, Formatting.EMPTY)), field.getAnnotations().stream().filter(it -> !TypeUtils.hasElementType((JavaType)it.getType(), (String)RuleFqn))).collect(Collectors.toList());
        field = field.withAnnotations(newAnnotations);
        List<J.VariableDecls.NamedVar> newVars = field.getVars().stream().map(it -> it.withInitializer(null)).map(it -> it.withName(it.getName().withFormatting(Formatting.EMPTY))).collect(Collectors.toList());
        Formatting originalTypeFormatting = (field = field.withVars(newVars)).getTypeExpr() == null ? Formatting.EMPTY : field.getTypeExpr().getFormatting();
        field = field.withTypeExpr((TypeTree)FileIdent.withFormatting(originalTypeFormatting));
        this.maybeAddImport((JavaType.FullyQualified)FileType);
        this.maybeAddImport((JavaType.FullyQualified)TempDirType);
        this.maybeRemoveImport(RuleFqn);
        this.maybeRemoveImport(TemporaryFolderFqn);
        newVars.forEach(fieldVar -> this.andThen((RefactorVisitor)new ReplaceTemporaryFolderMethods(fieldVar.getSimpleName())));
        this.andThen((RefactorVisitor)new AutoFormat(new J[]{field}));
        return field;
    }

    private static class AddNewFolderFunction
    extends JavaIsoRefactorVisitor {
        private AddNewFolderFunction() {
        }

        public J.ClassDecl visitClassDecl(J.ClassDecl cd) {
            boolean methodAlreadyExists = cd.getMethods().stream().anyMatch(m -> {
                List params = m.getParams().getParams();
                return m.getSimpleName().equals("newFolder") && params.size() == 2 && ((Statement)params.get(0)).hasClassType(FileType) && ((Statement)params.get(1)).hasClassType(StringType) && params.get(1) instanceof J.VariableDecls && ((J.VariableDecls)params.get(1)).getVarargs() != null;
            });
            if (!methodAlreadyExists) {
                ArrayList<J.MethodDecl> statements = new ArrayList<J.MethodDecl>(cd.getBody().getStatements());
                J.MethodDecl newFolderMethod = this.treeBuilder.buildMethodDeclaration(cd, "private static File newFolder(File root, String ... folders) throws IOException {\n    File result = new File(root, String.join(\"/\", folders));\n    if(!result.mkdirs()) {\n        throw new IOException(\"Couldn't create folders \" + root);\n    }\n    return result;\n}", new JavaType[]{FileType, IOExceptionType});
                statements.add(newFolderMethod);
                this.maybeAddImport((JavaType.FullyQualified)FileType);
                this.maybeAddImport((JavaType.FullyQualified)IOExceptionType);
                cd = cd.withBody(cd.getBody().withStatements(statements));
                this.andThen((RefactorVisitor)new AutoFormat(new J[]{newFolderMethod}));
            }
            return cd;
        }
    }

    private static class AddNewFileFunction
    extends JavaIsoRefactorVisitor {
        private AddNewFileFunction() {
        }

        public J.ClassDecl visitClassDecl(J.ClassDecl cd) {
            boolean methodAlreadyExists = cd.getMethods().stream().anyMatch(m -> {
                List params = m.getParams().getParams();
                return m.getSimpleName().equals("newFile") && params.size() == 2 && ((Statement)params.get(0)).hasClassType(FileType) && ((Statement)params.get(1)).hasClassType(StringType);
            });
            if (!methodAlreadyExists) {
                ArrayList<J.MethodDecl> statements = new ArrayList<J.MethodDecl>(cd.getBody().getStatements());
                J.MethodDecl newFileMethod = this.treeBuilder.buildMethodDeclaration(cd, "private static File newFile(File root, String fileName) throws IOException {\n    File file = new File(root, fileName);\n    file.createNewFile();\n    return file;\n}\n", new JavaType[]{FileType, IOExceptionType});
                statements.add(newFileMethod);
                this.maybeAddImport((JavaType.FullyQualified)FileType);
                this.maybeAddImport((JavaType.FullyQualified)IOExceptionType);
                cd = cd.withBody(cd.getBody().withStatements(statements));
                this.andThen((RefactorVisitor)new AutoFormat(new J[]{newFileMethod}));
            }
            return cd;
        }
    }

    private static class ReplaceTemporaryFolderMethods
    extends JavaRefactorVisitor {
        private final String fieldName;

        ReplaceTemporaryFolderMethods(String fieldName) {
            this.fieldName = fieldName;
            this.setCursoringOn();
        }

        public J visitMethodInvocation(J.MethodInvocation method) {
            J.MethodInvocation m = (J.MethodInvocation)this.refactor((Tree)method, x$0 -> super.visitMethodInvocation(x$0));
            if (!(m.getSelect() instanceof J.Ident)) {
                return m;
            }
            J.Ident receiver = (J.Ident)m.getSelect();
            if (receiver.getSimpleName().equals(this.fieldName) && m.getType() != null && TypeUtils.hasElementType((JavaType)m.getType().getDeclaringType(), (String)TemporaryFolderToTempDir.TemporaryFolderFqn)) {
                assert (this.getCursor().getParent() != null);
                List args = m.getArgs().getArgs();
                switch (m.getName().getSimpleName()) {
                    case "newFile": {
                        if (args.size() == 1 && args.get(0) instanceof J.Empty) {
                            m = (J.MethodInvocation)((J)this.treeBuilder.buildSnippet(this.getCursor().getParent(), "File.createTempFile(\"junit\", null, " + this.fieldName + ");", new JavaType[]{FileType}).get(0)).withFormatting(Formatting.format((String)" "));
                            break;
                        }
                        this.andThen((RefactorVisitor)new AddNewFileFunction());
                        m = (J.MethodInvocation)((J)this.treeBuilder.buildSnippet(this.getCursor().getParent(), "newFile(" + this.fieldName + ", " + ((Expression)args.get(0)).printTrimmed() + ");", new JavaType[]{FileType, ((Expression)args.get(0)).getType()}).get(0)).withFormatting(Formatting.format((String)" "));
                        break;
                    }
                    case "getRoot": {
                        return J.Ident.build((UUID)Tree.randomId(), (String)this.fieldName, (JavaType)FileType, (Formatting)m.getFormatting());
                    }
                    case "newFolder": {
                        if (args.size() == 1 && args.get(0) instanceof J.Empty) {
                            m = (J.MethodInvocation)((J)this.treeBuilder.buildSnippet(this.getCursor().getParent(), "Files.createTempDirectory(" + this.fieldName + ".toPath(), \"junit\").toFile();", new JavaType[]{FileType, FilesType, PathType}).get(0)).withFormatting(Formatting.format((String)" "));
                            this.maybeAddImport((JavaType.FullyQualified)FilesType);
                            break;
                        }
                        this.andThen((RefactorVisitor)new AddNewFolderFunction());
                        String argsString = ReplaceTemporaryFolderMethods.printArgs(m.getArgs().getArgs());
                        m = (J.MethodInvocation)((J)this.treeBuilder.buildSnippet(this.getCursor().getParent(), "newFolder(" + this.fieldName + ", " + argsString + ");", new JavaType[]{FileType}).get(0)).withFormatting(Formatting.format((String)" "));
                    }
                }
            }
            return m;
        }

        private static String printArgs(List<Expression> args) {
            return args.stream().map(J::print).collect(Collectors.joining(","));
        }
    }
}

