/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.util.ArrayList;
import java.util.List;
import org.openrewrite.AutoConfigure;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.java.AutoFormat;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.JavaIsoRefactorVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

@AutoConfigure
public class UpdateBeforeAfterAnnotations
extends JavaIsoRefactorVisitor {
    public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu) {
        ChangeType changeType = new ChangeType();
        changeType.setType("org.junit.Before");
        changeType.setTargetType("org.junit.jupiter.api.BeforeEach");
        this.andThen((RefactorVisitor)changeType);
        changeType = new ChangeType();
        changeType.setType("org.junit.After");
        changeType.setTargetType("org.junit.jupiter.api.AfterEach");
        this.andThen((RefactorVisitor)changeType);
        changeType = new ChangeType();
        changeType.setType("org.junit.BeforeClass");
        changeType.setTargetType("org.junit.jupiter.api.BeforeAll");
        this.andThen((RefactorVisitor)changeType);
        changeType = new ChangeType();
        changeType.setType("org.junit.AfterClass");
        changeType.setTargetType("org.junit.jupiter.api.AfterAll");
        this.andThen((RefactorVisitor)changeType);
        return super.visitCompilationUnit(cu);
    }

    public J.MethodDecl visitMethod(J.MethodDecl method) {
        J.MethodDecl m = super.visitMethod(method);
        boolean changed = false;
        ArrayList annotations = new ArrayList(m.getAnnotations());
        for (J.Annotation a : annotations) {
            if (!TypeUtils.isOfClassType((JavaType)a.getType(), (String)"org.junit.Before") && !TypeUtils.isOfClassType((JavaType)a.getType(), (String)"org.junit.After") && !TypeUtils.isOfClassType((JavaType)a.getType(), (String)"org.junit.BeforeClass") && !TypeUtils.isOfClassType((JavaType)a.getType(), (String)"org.junit.AfterClass")) continue;
            m = m.withModifiers(J.Modifier.withVisibility((List)m.getModifiers(), (String)"package"));
            this.andThen((RefactorVisitor)new AutoFormat(new J[]{m}));
            break;
        }
        return m;
    }
}

